#include <bits/stdc++.h>
using namespace std;

double norm(double x) {
    
    const double PI = acos(-1);
    while (x < 0) x += 2 * PI;
    while (x >= 2 * PI) x -= 2 * PI;
    return x;
}

double area(double a, double b, double c, double R) {

    double S = sin(b - a) + sin(c - b) + sin(a - c);
    return fabs(S) * R * R / 2.0;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const double PI = acos(-1);

    double R;
    cin >> R;

    vector<pair<double,double>> arc(3);

    for (int i = 0; i < 3; i++) {
        double l, r;
        cin >> l >> r;
        l = l * PI / 180.0;
        r = r * PI / 180.0;

        arc[i] = {norm(l), norm(r)};
    }

    double best = 0;
    for (int mask = 0; mask < 8; mask++) {
        double ang[3];
        for (int i = 0; i < 3; i++) {
            if (mask & (1 << i))
                ang[i] = arc[i].second;
            else
                ang[i] = arc[i].first;
        }
        best = max(best, area(ang[0], ang[1], ang[2], R));
    }

    cout << fixed << setprecision(10) << best << "\n";
    return 0;
}