#include <bits/stdc++.h>
using namespace std;
using u128 = unsigned __int128;
using u64 = unsigned long long;
u64 modmul(u64 a, u64 b, u64 mod) {
    u128 res = (u128)a * b;
    res %= mod;
    return (u64)res;
}
u64 modpow(u64 a, u64 d, u64 mod) {
    u64 res = 1;
    while (d) {
        if (d & 1) res = modmul(res, a, mod);
        a = modmul(a, a, mod);
        d >>= 1;
    }
    return res;
}
bool isPrime64(u64 n) {
    if (n < 2) return false;
    for (u64 p : {2ull,3ull,5ull,7ull,11ull,13ull,17ull,19ull,23ull,29ull,31ull,37ull}) {
        if (n%p==0) return n==p;
    }
    u64 d = n - 1, s = 0;
    while ((d & 1) == 0) { d >>= 1; ++s; }
    u64 bases[] = {2ULL, 325ULL, 9375ULL, 28178ULL, 450775ULL, 9780504ULL, 1795265022ULL};
    for (u64 a : bases) {
        if (a % n == 0) continue;
        u64 x = modpow(a % n, d, n);
        if (x == 1 || x == n-1) continue;
        bool composite = true;
        for (u64 r = 1; r < s; ++r) {
            x = modmul(x, x, n);
            if (x == n-1) { composite = false; break; }
        }
        if (composite) return false;
    }
    return true;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    if (!(cin >> t)) return 0;
    while (t--) {
        int n;
        cin >> n;
        long long xr = 0;
        for (int i = 0; i < n; ++i) {
            unsigned long long s;
            cin >> s;
            if (isPrime64(s)) {
            } else if (s % 2 == 1) {
            } else {
                if ((s & (s - 1)) == 0) {
                    xr ^= 1;
                } else {
                    xr ^= 2;
                }
            }
        }
        cout << (xr ? "Yes" : "No") << '\n';
    }
    return 0;
}