#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    if (n == 1) {
        cout << "No\n";
        return 0;
    }

    vector<int> p(n * n);
    iota(p.begin(), p.end(), 1);

    mt19937_64 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

    while (true) {
        shuffle(p.begin(), p.end(), rng);

        vector<long long> row(n, 0), col(n, 0);
        long long d1 = 0, d2 = 0;

        for (int i = 0, k = 0; i < n; i++)
            for (int j = 0; j < n; j++, k++) {
                int x = p[k];
                row[i] += x;
                col[j] += x;
                if (i == j) d1 += x;
                if (i + j == n - 1) d2 += x;
            }

        vector<long long> sums;
        sums.reserve(2*n + 2);
        for (int i = 0; i < n; i++) sums.push_back(row[i]);
        for (int i = 0; i < n; i++) sums.push_back(col[i]);
        sums.push_back(d1);
        sums.push_back(d2);

        sort(sums.begin(), sums.end());
        bool ok = true;
        for (int i = 1; i < (int)sums.size(); i++)
            if (sums[i] == sums[i-1]) { ok = false; break; }

        if (ok) {
            cout << "Yes\n";
            for (int i = 0, k = 0; i < n; i++) {
                for (int j = 0; j < n; j++, k++) {
                    cout << p[k] << " ";
                }
                cout << "\n";
            }
            return 0;
        }
    }
}
