#include <bits/stdc++.h>
using namespace std;
using ll = long long;

bool check_antimagic(const vector<vector<int>>& a) {
    int n = (int)a.size();
    vector<ll> sums;
    sums.reserve(2*n + 2);
    // rows
    for (int i = 0; i < n; ++i) {
        ll s = 0;
        for (int j = 0; j < n; ++j) s += a[i][j];
        sums.push_back(s);
    }
    // cols
    for (int j = 0; j < n; ++j) {
        ll s = 0;
        for (int i = 0; i < n; ++i) s += a[i][j];
        sums.push_back(s);
    }
    // diag1
    ll d1 = 0, d2 = 0;
    for (int i = 0; i < n; ++i) {
        d1 += a[i][i];
        d2 += a[i][n-1-i];
    }
    sums.push_back(d1);
    sums.push_back(d2);

    sort(sums.begin(), sums.end());
    for (int i = 1; i < (int)sums.size(); ++i)
        if (sums[i] == sums[i-1]) return false;
    return true;
}

vector<vector<int>> gen_row_snake(int n) {
    vector<vector<int>> a(n, vector<int>(n));
    int cur = 1;
    for (int i = 0; i < n; ++i) {
        if (i % 2 == 0)
            for (int j = 0; j < n; ++j) a[i][j] = cur++;
        else
            for (int j = n-1; j >= 0; --j) a[i][j] = cur++;
    }
    return a;
}

vector<vector<int>> gen_col_snake(int n) {
    vector<vector<int>> a(n, vector<int>(n));
    int cur = 1;
    for (int j = 0; j < n; ++j) {
        if (j % 2 == 0)
            for (int i = 0; i < n; ++i) a[i][j] = cur++;
        else
            for (int i = n-1; i >= 0; --i) a[i][j] = cur++;
    }
    return a;
}

vector<vector<int>> gen_formula_shift_rows(int n, int k) {
    // base row-wise increasing, then shift row i by (i*k) mod n
    vector<vector<int>> b(n, vector<int>(n));
    int cur = 1;
    for (int i = 0; i < n; ++i)
        for (int j = 0; j < n; ++j)
            b[i][j] = cur++;
    vector<vector<int>> a(n, vector<int>(n));
    for (int i = 0; i < n; ++i)
        for (int j = 0; j < n; ++j)
            a[i][(j + (i * k) % n) % n] = b[i][j];
    return a;
}

vector<vector<int>> transpose(const vector<vector<int>>& a) {
    int n = (int)a.size();
    vector<vector<int>> b(n, vector<int>(n));
    for (int i = 0; i < n; ++i)
        for (int j = 0; j < n; ++j)
            b[j][i] = a[i][j];
    return b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;

    if (n == 1 || n == 2) {
        cout << "No\n";
        return 0;
    }

    // Special known valid 3x3 from statement
    if (n == 3) {
        cout << "Yes\n";
        cout << "9 7 3\n4 2 5\n8 1 6\n";
        return 0;
    }

    // Try a bunch of deterministic generators (cheap checks)
    vector<vector<vector<int>>> candidates;

    candidates.push_back(gen_col_snake(n));
    candidates.push_back(gen_row_snake(n));
    // try shifting rows with small k values (k coprime or not)
    int maxK = min(n-1, 50);
    for (int k = 1; k <= maxK; ++k) {
        candidates.push_back(gen_formula_shift_rows(n, k));
    }
    // also try transposes of some
    int baseSz = (int)candidates.size();
    for (int i = 0; i < baseSz; ++i)
        candidates.push_back(transpose(candidates[i]));

    for (auto &cand : candidates) {
        if (check_antimagic(cand)) {
            cout << "Yes\n";
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) cout << cand[i][j] << (j+1==n?'\n':' ');
            }
            return 0;
        }
    }

    // As a last resort, limited randomized search (should very rarely be needed).
    // We'll try a few shuffles of row order and of each row internally.
    mt19937_64 rng(chrono::high_resolution_clock::now().time_since_epoch().count());
    vector<int> base(n*n);
    iota(base.begin(), base.end(), 1);

    int attempts = 0;
    const int MAX_ATTEMPTS = 200;
    while (attempts++ < MAX_ATTEMPTS) {
        // create matrix by filling rows with random permutations of blocks
        shuffle(base.begin(), base.end(), rng);
        vector<vector<int>> a(n, vector<int>(n));
        int k = 0;
        for (int i = 0; i < n; ++i)
            for (int j = 0; j < n; ++j)
                a[i][j] = base[k++];
        // optionally permute columns randomly
        if (check_antimagic(a)) {
            cout << "Yes\n";
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) cout << a[i][j] << (j+1==n?'\n':' ');
            }
            return 0;
        }
    }

    // If nothing found (extremely unlikely), print No (failsafe)
    cout << "No\n";
    return 0;
}


