#include "testlib.h"
#include "constants.h"

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int t = inf.readInt(1, constants::MAX_T, "t");
    inf.readEoln();

    long long sum_n = 0;

    for (int tc = 1; tc <= t; ++tc) {
        setTestCase(tc);

        int n = inf.readInt(1, constants::MAX_N, "n");
        inf.readEoln();

        sum_n += n;
        ensuref(sum_n <= constants::SUM_N_LIMIT,
                "sum of nq over all datasets must be <= %d, got %lld after dataset #%d",
                constants::SUM_N_LIMIT, sum_n, tc);

        inf.readLongs(n, 2, constants::MAX_S, "~s~");
        inf.readEoln();
    }

    inf.readEof();
}
