#include <bits/stdc++.h>

#include "testlib.h"

using namespace std;

struct Event {
    long long t;
    string name;
    long long len;
};

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);

    long long N = opt<long long>(1, 3);
    long long M = opt<long long>(2, 50);
    long long songLen = opt<long long>(3, 2);
    long long T0 = opt<long long>(4, 100);

    vector<pair<string, long long>> base;
    for (long long i = 0; i < N; ++i) {
        int L = 3 + (int)(i % 3);
        string name = rnd.next("[A-Za-z]{" + toString(L) + "}");
        base.emplace_back(name, songLen);
    }

    long long total = songLen * N;
    if (T0 <= total) {
        T0 = total + 1;
    }

    vector<Event> events;
    for (long long j = 0; j < M; ++j) {
        int L = 5 + (int)(j % 5);
        string ename = rnd.next("[A-Za-z]{" + toString(L) + "}");
        long long elen = songLen;
        events.push_back({T0, ename, elen});
    }

    stable_sort(events.begin(), events.end(),
                [](const Event& a, const Event& b) { return a.t < b.t; });

    println(N);
    for (auto& p : base) {
        cout << p.first << ' ' << p.second << '\n';
    }
    println((int)events.size());
    for (auto& e : events) {
        cout << e.t << ' ' << e.name << ' ' << e.len << '\n';
    }
    return 0;
}
