#include "testlib.h"
#include "constants.h"

using namespace std;

using ll = long long;

int get(int from, int to) {
    return rnd.next(from, to);
}

ll get_ll(ll from, ll to) {
    return rnd.next(from, to);
}

template<typename T>
T get_opt(const string &key, const T &d) {
    return has_opt(key) ? opt<T>(key) : d;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int t = get_opt("t", constants::MAX_T);
    int maxn = get_opt("n", constants::MAX_N);
    int maxX = get_opt("X", constants::MAX_X);
    int maxC = get_opt("c", constants::MAX_C);

    int max_test = get_opt("max", 0);

    int min_gen = 1;

    if (max_test) {
        t = 1;
        min_gen = constants::MAX_N;
    }


    const int TOTAL_N_LIMIT = constants::SUM_N_LIMIT;

    cout << t << "\n";

    ll sum_n = 0;
    for (int ti = 0; ti < t; ti++) {
        int remaining_tests = t - ti;
        int remaining_budget = TOTAL_N_LIMIT - sum_n;
        int max_allowable_n = min(maxn, remaining_budget - (remaining_tests - 1));
        int n = get(min_gen, max_allowable_n);
        sum_n += n;

        ll X;
        do {
            X = get_ll(-maxX, maxX);
        } while (X == 0);

        cout << n << " " << X << "\n";

        for (int i = 0; i < n; i++) {
            int xi = get(1, maxX);
            cout << xi;
            if (i != n - 1) cout << ' ';
        }
        cout << '\n';
        for (int i = 0; i < n; i++) {
            ll ci = get_ll(1, maxC);
            cout << ci;
            if (i != n - 1) cout << ' ';
        }
        cout << '\n';
    }
}
