#include "testlib.h"
#include "constants.h"

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int t = inf.readInt(1, constants::MAX_T, "t");
    inf.readEoln();

    long long sum_n = 0;

    for (int tc = 1; tc <= t; ++tc) {
        setTestCase(tc);

        int n = inf.readInt(1, constants::MAX_N, "n");
        inf.readSpace();
        int L = inf.readInt(-constants::MAX_X, constants::MAX_X, "L");
        ensuref(L != 0, "L shouldn't be equal to 0");
        inf.readEoln();

        sum_n += n;
        ensuref(sum_n <= constants::SUM_N_LIMIT,
                "sum of nq over all datasets must be <= %d, got %lld after dataset #%d",
                constants::SUM_N_LIMIT, sum_n, tc);
        inf.readInts(n, 1, constants::MAX_X, "jumps");
        inf.readEoln();
        inf.readInts(n, 1, constants::MAX_C, "costs");
        inf.readEoln();
    }

    inf.readEof();
}
