#include <bits/stdc++.h>

using ll = long long;
const ll inf = 1e18;

#define int ll

const int mod = 998244353;

int add(int a, int b) {
    return (a + b) >= mod ? a + b - mod : a + b;
}
int sub(int a, int b) {
    return a >= b ? a - b : a + mod - b;
}
int mul(int a, int b) {
    return 1ll * a * b % mod;
}
int power(int a, int b) {
    int ret = 1;
    for (; b; b >>= 1, a = mul(a, a)) {
        if (b & 1) ret = mul(ret, a);
    }
    return ret;
}
int inv(int x) {
    return power(x, mod - 2);
}

int i2 = inv(2), i6 = inv(6);

void norm(ll& x) {
    x = (x % mod + mod) % mod;
}

int S2(ll n) {
    norm(n);
    return mul(mul(n, sub(n, 1)), mul(sub(mul(2, n), 1), i6));
}
int S(ll n) {
    norm(n);
    return mul(mul(n, sub(n, 1)), i2);
}
int S2(ll n, ll k, ll r) {
    norm(n), norm(k), norm(r);
    return add(add(mul(mul(k, k), S2(n)), mul(S(n), mul(2, mul(k, r)))), mul(n, mul(r, r)));
}
ll S(ll n, ll k, ll r) {
    norm(n), norm(k), norm(r);
    return add(mul(S(n), k), mul(n, r));
}

signed main() {
    std::cin.tie(nullptr)->sync_with_stdio(false);

    ll n;
    std::cin >> n;
    int ans = 0;
    for (ll l = 1; l <= n; ) {
        ll r = n / (n / l);
        ll x = n / l;
        int full = mul(mul(x, i2), sub(sub(S2(r + 1), S2(l)), sub(S(r + 1), S(l))));
        ll tl = n % l;
        int part = mul(add(S2(r - l + 1, -x, tl), S(r - l + 1, -x, tl)), i2);
//        std::cout << l << ' ' << r << ' ' << x << ' ' << full << ' ' << part << ' ' << tl << ' ' << S2(r - l + 1, -x, tl) << ' ' << sub(S2(r), S2(l - 1)) << std::endl;
        ans = add(ans, add(full, part));
        l = r + 1;
    }
    std::cout << ans;
}
/*
5
 3 4 3 2 1
 3
 3 5
4 4
 5 3
 */