#include <iostream>
#include <algorithm>
#include <vector>
#include <string>
#include <deque>

using ll = long long;
using namespace std;

struct edge {
	int pref0, pref1, suff0, suff1, otv, l, pref, suff;
};

const int maxn = 131072, inf = (int)1e8;
int ch[maxn], a[maxn];
edge t[2 * maxn];

edge merge(edge& left, edge& right) {
	edge otv;
	otv.l = left.l + right.l;
	otv.pref0 = left.pref0 + (left.pref0 == left.l ? right.pref0 : 0);
	otv.pref1 = left.pref1 + (left.pref1 == left.l ? right.pref1 : 0);
	otv.suff0 = right.suff0 + (right.suff0 == right.l ? left.suff0 : 0);
	otv.suff1 = right.suff1 + (right.suff1 == right.l ? left.suff1 : 0);

	otv.pref = (left.pref0 == left.l ? right.pref : left.pref + (left.pref0 + left.pref == left.l ? right.pref1 : 0));
	otv.suff = (right.suff1 == right.l ? left.suff : right.suff + (right.suff1 + right.suff == right.l ? left.suff0 : 0));

	otv.otv = max(max(left.otv, right.otv), max(min(left.suff, left.suff1 + right.pref1), min(left.suff0 + right.pref0, right.pref)));
	return otv;
}

void build(int v, int tl, int tr) {
	if (tl + 1 == tr) {
		a[tl] = ch[tr] - ch[tl];
		a[tl] = (a[tl] == 1 ? 0 : (a[tl] == -1 ? 1 : inf));
		t[v] = { a[tl] == 0, a[tl] == 1, a[tl] == 0, a[tl] == 1, 0, 1, a[tl] == 1, a[tl] == 0 };
		return;
	}
	int tm = (tl + tr) / 2;
	build(2 * v + 1, tl, tm);
	build(2 * v + 2, tm, tr);
	t[v] = merge(t[2 * v + 1], t[2 * v + 2]);
}

void update(int v, int tl, int tr, int p) {
	if (tl + 1 == tr) {
		a[tl] = ch[tr] - ch[tl];
		a[tl] = (a[tl] == 1 ? 0 : (a[tl] == -1 ? 1 : inf));
		t[v] = { a[tl] == 0, a[tl] == 1, a[tl] == 0, a[tl] == 1, 0, 1, a[tl] == 1, a[tl] == 0 };
		return;
	}
	int tm = (tl + tr) / 2;
	if (p < tm) update(2 * v + 1, tl, tm, p);
	else update(2 * v + 2, tm, tr, p);
	t[v] = merge(t[2 * v + 1], t[2 * v + 2]);
}

signed main() {
	ios::sync_with_stdio(0);
	cin.tie(0); cout.tie(0);
	for (int i = 0; i < maxn; i++) ch[i] = (i % 2 ? inf : -inf);

	int n; cin >> n;
	for (int i = 0; i < n; i++) cin >> ch[i];
	build(0, 0, maxn);
	cout << 2 * t[0].otv + 1 << "\n";

	int q, p, x; cin >> q;
	while (q--) {
		cin >> p >> x; p--;
		ch[p] = x;
		update(0, 0, maxn, p);
		if (p) update(0, 0, maxn, p - 1);
		cout << t[0].otv * 2 + 1 << "\n";
	}
	return 0;
}
