#include <iostream>
#include <algorithm>
#include <vector>
#include <random>
#include <set>

using ll = long long;
using ld = long double;
using namespace std;
mt19937 rnd(141);

bool check(int n, vector <int>& str, vector <int>& stb, int d1, int d2) {
	set <int> s;
	s.insert(d1);
	s.insert(d2);
	for (int i = 0; i < n; i++) {
		s.insert(str[i]);
		s.insert(stb[i]);
	}
	return ((int)s.size() == 2 * n + 2);
}

void print(vector <vector <int>>& a) {
	for (auto &i : a) {
		for (auto j : i) cout << j << " ";
		cout << "\n";
	}
	exit(0);
}

signed main() {
	ios::sync_with_stdio(0);
	cin.tie(0); cout.tie(0);

	int n; cin >> n;
	if (n <= 2) {
		cout << "No\n";
		return 0;
	}
	cout << "Yes\n";
	vector <vector <int>> a(n, vector <int>(n, 0));
	for (int i = 0; i < n; i++) for (int j = 0; j < n; j++) a[i][j] = n * i + j + 1;
	vector <int> str(n, 0), stb(n, 0);
	int d1 = 0, d2 = 0, x1, y1, x2, y2;
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (i == j) d1 += a[i][j];
			if (i == n - j - 1) d2 += a[i][j];
			str[i] += a[i][j];
			stb[j] += a[i][j];
		}
	}
	while (true) {
		if (check(n, str, stb, d1, d2)) print(a);
		x1 = rnd() % n; 
		y1 = rnd() % n;
		x2 = rnd() % n;
		y2 = rnd() % n;
		if (x1 == y1 && x2 == y2) continue;
		str[x1] -= a[x1][y1];
		stb[y1] -= a[x1][y1];
		str[x1] += a[x2][y2];
		stb[y1] += a[x2][y2];
		str[x2] -= a[x2][y2];
		stb[y2] -= a[x2][y2];
		str[x2] += a[x1][y1];
		stb[y2] += a[x1][y1];
		if (x1 == y1) d1 += a[x2][y2] - a[x1][y1];
		if (x1 == n - y1 - 1) d2 += a[x2][y2] - a[x1][y1];
		if (x2 == y2) d1 += a[x1][y1] - a[x2][y2];
		if (x2 == n - y2 - 1) d2 += a[x1][y1] - a[x2][y2];
		swap(a[x1][y1], a[x2][y2]);
	}
	return 0;
}
