#include <bits/stdc++.h>

using namespace std;

using str = string;
using pii = pair<int, int>;

//#define int long long


struct bl {
    int x, y;

    bl() : x(0), y(0) {}
    bl(int val) {
        x = y = 0;
        if (val == 1) x = 1;
        if (val == -1) y = 1;
    }
};

struct node {
    int ans, sz;
    bl l, r;

    node() : ans(0), sz(0), l(), r() {}
    node(int x) : ans(0), sz(1), l(x), r(x) {}
};

pii get(bl &l, bl &r) {
    if (l.y == 0) {
        int x = l.x + r.x;
        int y = r.y;
        return {x, y};
    }
    if (r.x == 0) {
        int x = l.x;
        int y = l.y + r.y;
        return {x, y};
    }
    return {0, 0};
}
pii getl(bl &l, bl &r) {
    if (l.y == 0) {
        int x = l.x + r.x;
        int y = r.y;
        return {x, y};
    }
    if (r.x == 0) {
        int x = l.x;
        int y = l.y + r.y;
        return {x, y};
    }
    return {l.x, l.y};
}
pii getr(bl &l, bl &r) {
    if (l.y == 0) {
        int x = l.x + r.x;
        int y = r.y;
        return {x, y};
    }
    if (r.x == 0) {
        int x = l.x;
        int y = l.y + r.y;
        return {x, y};
    }
    return {r.x, r.y};
}

node operator+(node &a, node &b) {
    node res;
    res.ans = max(a.ans, b.ans);
    pii p = get(a.r, b.l);
    res.ans = max(res.ans, 2 * min(p.first, p.second));
    res.sz = a.sz + b.sz;

    if (a.l.x + a.l.y < a.sz) {
        res.l = a.l;
    } else {
        p = getl(a.l, b.l);
        res.l.x = p.first;
        res.l.y = p.second;
    }

    if (b.r.x + b.r.y < b.sz) {
        res.r = b.r;
    } else {
        p = getr(a.r, b.r);
        res.r.x = p.first;
        res.r.y = p.second;
    }
    return res;
}


struct seg_tree {
    int sz;
    vector<int> a;
    vector<node> t;

    seg_tree(vector<int> &arr) {
        sz = (int) arr.size();
        a = arr;
        t.resize(4 * sz);
        build(0, 0, sz);
    }

    void build(int v, int l, int r) {
        if (l + 1 == r) {
            t[v] = node(a[l]);
            return;
        }
        int m = (l + r) / 2;
        int l_u = 2 * v + 1, r_u = l_u + 1;
        build(l_u, l, m);
        build(r_u, m, r);
        t[v] = t[l_u] + t[r_u];
    }

    void upd(int ind, int x) {
        upd(0, 0, sz, ind, x);
    }
    void upd(int v, int l, int r, int ind, int x) {
        if (l + 1 == r) {
            t[v] = node(x);
            return;
        }
        int m = (l + r) / 2;
        int l_u = 2 * v + 1, r_u = l_u + 1;
        if (ind < m) {
            upd(l_u, l, m, ind, x);
        } else {
            upd(r_u, m, r, ind, x);
        }
        t[v] = t[l_u] + t[r_u];
    }

    int get() {
        return t[0].ans;
    }
};


signed main() {
#ifdef LOCAL
    freopen("inp.txt", "r", stdin);
    freopen("out.txt", "w", stdout);
#endif
    cin.tie(0);
    cin.sync_with_stdio(0);
    cout.tie(0);
    cout.sync_with_stdio(0);


    int n;
    cin >> n;
    vector<int> a(n);
    for (auto &i : a) cin >> i;


    vector<int> b(n - 1);
    for (int i = 0; i < n - 1; i++) {
        b[i] = a[i + 1] - a[i];
    }
    seg_tree st(b);
    cout << st.get() + 1 << "\n";
    int q;
    cin >> q;
    for (int i = 0; i < q; i++) {
        int ind, x;
        cin >> ind >> x;
        ind--;
        a[ind] = x;
        if (ind == 0) {
            b[ind] = a[ind + 1] - a[ind];
            st.upd(ind, b[ind]);
        } else if (ind == n - 1) {
            b[ind - 1] = a[ind] - a[ind - 1];
            st.upd(ind - 1, b[ind - 1]);
        } else {
            b[ind] = a[ind + 1] - a[ind];
            st.upd(ind, b[ind]);
            b[ind - 1] = a[ind] - a[ind - 1];
            st.upd(ind - 1, b[ind - 1]);
        }
        cout << st.get() + 1 << "\n";
    }
}