#include "bits/stdc++.h"

using namespace std;

const int MAXV = 500 + 10;

void intersect(set<int>& a, set<int>& b) {
    vector<int> v(a.begin(), a.end());
    for (int i : v) {
        if (b.find(i) == b.end()) a.erase(i);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m, k;
    cin >> n >> m >> k;

    vector<int> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
        a[i] = a[i];
    }
    vector<vector<int>> b(m, vector<int>(n));
    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            cin >> b[i][j];
            b[i][j] = b[i][j];
        }
    }

    set<int> win, loss;
    for (int i = 0; i < m; ++i) loss.insert(i);
    vector<int> stay(m, n);
    vector<vector<vector<int>>> mv(n, vector<vector<int>>(MAXV));

    for (int i = 0; i < m; ++i) {
        for (int j = 0; j < n; ++j) {
            if (b[i][j] <= a[j]) stay[i]--;
            else mv[j][b[i][j]].push_back(i);
        }
    }

    vector<set<int>> good(n);
    for (int i = 0; i < n; ++i) for (int j = 0; j < m; ++j) {
        good[i].insert(j);
    }

    for (int i = 0; i < m; ++i) if (stay[i] == 0) {
        loss.erase(i);
        win.insert(i);
    }

    while (k--) {
        int t;
        cin >> t;

        if (t == 1) {
            int i, x;
            cin >> i >> x;
            --i;

            while (x > 0 && a[i] < MAXV - 5) {
                ++a[i];
                --x;

                for (auto j: mv[i][a[i]]) {
                    stay[j]--;
                    if (stay[j] == 0) {
                        win.insert(j);
                        loss.erase(j);
                    }
                }
            }
        } else {
            int i;
            string s;
            cin >> i >> s;
            --i;

            if (s == "win") {
                intersect(good[i], win);
            } else {
                intersect(good[i], loss);
            }
        }
    }

    for (int i = 0; i < good.size(); ++i) {
        if (good[i].size() == 0) {
            cout << "No";
            return 0;
        }
    }
    cout << "Yes";
}
