#include "testlib.h"
#include "constants.h"

using ll = long long;

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int t = inf.readInt(1, constants::MAX_T, "t");
    inf.readEoln();

    ll sum_n = 0, sum_m = 0, sum_q = 0;

    for (int tc = 1; tc <= t; ++tc) {
        setTestCase(tc);
        int n = inf.readInt(1, constants::MAX_N, "n");
        inf.readSpace();

        ll pairBound = 1LL * n * (n - 1) / 2;
        int mUpper = (int) std::min<ll>(constants::MAX_M, pairBound);
        int m = inf.readInt(0, mUpper, "m");
        inf.readSpace();

        int q = inf.readInt(1, constants::MAX_Q, "q");
        inf.readEoln();

        sum_n += n;
        sum_m += m;
        sum_q += q;
        ensuref(sum_n <= constants::SUM_N_LIMIT,
                "sum of n over all tests must be <= %lld, got %lld after test #%d",
                constants::SUM_N_LIMIT, sum_n, tc);
        ensuref(sum_m <= constants::SUM_M_LIMIT,
                "sum of m over all tests must be <= %lld, got %lld after test #%d",
                constants::SUM_M_LIMIT, sum_m, tc);
        ensuref(sum_q <= constants::SUM_Q_LIMIT,
                "sum of q over all tests must be <= %lld, got %lld after test #%d",
                constants::SUM_Q_LIMIT, sum_q, tc);

        auto xs = inf.readInts(n, -constants::MAX_COORD, constants::MAX_COORD, "~x~");
        inf.readEoln();

        auto ys = inf.readInts(n, -constants::MAX_COORD, constants::MAX_COORD, "~y~");
        inf.readEoln();

        std::set<std::pair<int, int>> st;
        for (int i = 0; i < n; i++) {
            st.insert({xs[i], ys[i]});
        }
        ensuref(st.size() == n, "not all villages are identical");

        for (int i = 0; i < m; ++i) {
            auto e = inf.readInts(2, 1, n, "~e~");
            inf.readEoln();
        }

        inf.readInts(q, -constants::MAX_COORD, constants::MAX_COORD, "~cut~");
        inf.readEoln();
    }

    inf.readEof();
    return 0;
}
