#include <iostream>
#include <vector>

using namespace std;

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

using graph = vector<vector<int>>;

void dfs(const vector<int> &xs, const graph &g, vector<bool> &used, int v, int x) {
    used[v] = true;
    for (auto to: g[v]) {
        if (!used[to] && !(min(xs[v], xs[to]) <= x && x <= max(xs[v], xs[to]))) {
            dfs(xs, g, used, to, x);
        }
    }
}

void solve() {
    int n, m, q;
    cin >> n >> m >> q;

    vector<int> xs(n), ys(n);
    cin >> xs >> ys;
    graph g(n);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        g[u].push_back(v);
        g[v].push_back(u);
    }

    while (q--) {
        int x, res = 0;
        cin >> x;
        vector<bool> used(n);
        for (int i = 0; i < n; i++) {
            if (xs[i] != x && !used[i]) dfs(xs, g, used, i, x), res++;
        }
        cout << res << ' ';
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin >> tests;
    while (tests--) {
        solve();
        cout << '\n';
    }
}
