#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

using dl = long double;

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}


const dl eps = 1e-9;
const dl inf = 1e18;

bool check(dl mid, int k, int r, const vector<dl> &a, const vector<dl> &x) {
    int idx = 0;
    int cnt = 0;

    dl last = -inf;

    for (int i = 0; i < x.size(); i++) {
        if (abs(x[i] - last) <= mid + eps) continue;
        while (idx < a.size() && abs(a[idx] - x[i]) > mid && a[idx] < x[i]) idx++;
        if (idx != a.size()) last = a[idx];
        if (abs(x[i] - last) <= mid + eps) continue;
        cnt++;
        last = x[i] + mid;
    }
    return cnt <= k - r;
}

void solve() {
    int n, q;
    cin >> n >> q;
    vector<dl> x(n);
    cin >> x;
    sort(x.begin(), x.end());
    while (q--) {
        int k, r;
        cin >> k >> r;
        vector<dl> a(r);
        cin >> a;
        sort(a.begin(), a.end());

        dl left = 0, right = 1e18;
        for (int step = 0; step < 100; step++) {
            dl mid = (left + right) / 2;
            if (check(mid, k, r, a, x)) {
                right = mid;
            } else {
                left = mid;
            }
        }
        cout << right << ' ';
    }
}

signed main() {
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests = 1;
    cin >> tests;

    std::cout << std::fixed << std::setprecision(6) << '\n';

    while (tests--) {
        solve();
        cout << '\n';
    }
}
