#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;

static const ld INF = 1e30L;

int ub_ld_on_ll(const vector<ll>& v, int from, ld val) {
    // первый индекс > val; v — целые, поэтому достаточно upper_bound по floor(val)
    ll key = (ll) floor(val);
    auto it = upper_bound(v.begin() + from, v.end(), key);
    return (int)(it - v.begin());
}

bool feasible(ld R, const vector<ll>& X, const vector<ll>& A_sorted, long long k) {
    int n = (int)X.size();
    int r = (int)A_sorted.size();
    // построим и сольём интервалы от фиксированных центров
    vector<pair<ld,ld>> segs;
    segs.reserve(r);
    for (ll a : A_sorted) segs.emplace_back((ld)a - R, (ld)a + R);
    sort(segs.begin(), segs.end());
    vector<pair<ld,ld>> merged;
    for (auto &iv : segs) {
        if (merged.empty() || iv.first > merged.back().second) {
            merged.push_back(iv);
        } else {
            merged.back().second = max(merged.back().second, iv.second);
        }
    }

    long long need = 0;           // сколько доп. центров нужно
    int i = 0;                    // указатель по людям
    ld twoR = 2.0L * R;

    // перед первой дырой: если нет фиксированных интервалов, merged пуст
    for (auto &iv : merged) {
        ld L = iv.first, RR = iv.second;

        // закрываем людей строго левее L
        while (i < n && (ld)X[i] < L) {
            // ставим центр, покрывающий [X[i], X[i] + 2R]
            need++;
            if (need + (long long)A_sorted.size() > k) return false; // ранний выход
            ld reach = (ld)X[i] + twoR;
            i = ub_ld_on_ll(X, i, reach);
        }

        // пролистываем тех, кто накрыт текущим фиксированным интервалом
        if (i < n && (ld)X[i] <= RR) {
            i = ub_ld_on_ll(X, i, RR);
        }
    }

    // закрываем «хвост» после последнего фиксированного интервала
    while (i < n) {
        need++;
        if (need + (long long)A_sorted.size() > k) return false;
        ld reach = (ld)X[i] + twoR;
        i = ub_ld_on_ll(X, i, reach);
    }

    return (need + (long long)A_sorted.size() <= k);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    if (!(cin >> T)) return 0;
    cout.setf(std::ios::fixed);
    cout << setprecision(12);

    while (T--) {
        int n, q;
        cin >> n >> q;
        vector<ll> X(n);
        for (int i=0;i<n;i++) cin >> X[i];
        sort(X.begin(), X.end());

        vector<ld> answers(q);

        for (int qi=0; qi<q; ++qi) {
            long long k; int r;
            cin >> k >> r;
            vector<ll> A(r);
            for (int j=0;j<r;j++) cin >> A[j];
            sort(A.begin(), A.end());

            // бинпоиск по R
            ld lo = 0.0L, hi = 2.0e9L + 10.0L; // верхняя граница гарантированно достаточна
            for (int it=0; it<70; ++it) {      // 70 итераций с запасом до ~1e-21
                ld mid = (lo + hi) / 2.0L;
                if (feasible(mid, X, A, k)) hi = mid; else lo = mid;
            }
            answers[qi] = hi;
        }

        // вывод — одна строка из q чисел
        for (int i=0;i<q;i++) {
            if (i) cout << ' ';
            cout << (double)answers[i];
        }
        cout << "\n";
    }
    return 0;
}
