#include "testlib.h"
#include "constants.h"

#include <vector>
#include <algorithm>

using ll = long long;

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int t = inf.readInt(1, constants::MAX_T, "t");
    inf.readEoln();

    ll sum_n = 0;

    for (int test = 1; test <= t; ++test) {
        setTestCase(test);

        int n = inf.readInt(1, constants::MAX_N, "n");
        inf.readSpace();
        int m = inf.readInt(1, std::min(constants::MAX_M, n), "m");
        inf.readEoln();

        sum_n += n;
        ensuref(sum_n <= constants::SUM_N_LIMIT,
                "sum of n over all tests must be <= %lld, got %lld after test #%d",
                constants::SUM_N_LIMIT, sum_n, test);

        inf.readInts(n, -constants::MAX_COORD, constants::MAX_COORD, "~x~");
        inf.readEoln();
        inf.readInts(n, -constants::MAX_COORD, constants::MAX_COORD, "~y~");
        inf.readEoln();

        std::vector<int> cnt = inf.readInts(m, 1, n, "~cnt~");
        inf.readEoln();

        ensuref(cnt[0] == 1,
                "x1 must be equal to 1, got %d in test #%d", cnt[0], test);

        ll sum_cnt = 0;
        for (int v: cnt) sum_cnt += v;

        ensuref(sum_cnt <= n,
                "sum of x_i must be <= n, got %lld while n = %d in test #%d",
                sum_cnt, n, test);
    }

    inf.readEof();
}
