#include "testlib.h"
#include "constants.h"

using namespace std;

using ll = long long;

template<typename T>
T get_opt(const string &key, const T &def) {
    return has_opt(key) ? opt<T>(key) : def;
}

static vector<int> split_positive_sum(int parts, int sum) {
    if (parts == 1) return {sum};
    vector<int> cuts;
    cuts.reserve(parts - 1);
    set<int> used;
    while ((int) used.size() < parts - 1) {
        int x = rnd.next(1, sum - 1);
        used.insert(x);
    }
    for (int x: used) cuts.push_back(x);
    sort(cuts.begin(), cuts.end());
    vector<int> res;
    res.reserve(parts);
    int prev = 0;
    for (int c: cuts) {
        res.push_back(c - prev);
        prev = c;
    }
    res.push_back(sum - prev);
    return res;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    const int want_t = get_opt<int>("t", constants::MAX_T);
    const int min_n = get_opt<int>("min_n", 1);
    const int max_n = get_opt<int>("max_n", constants::MAX_N);
    const int coord_lim = get_opt<int>("coord", constants::MAX_COORD);
    const int kmax_opt = get_opt<int>("kmax", (int) constants::MAX_M);

    vector<tuple<int, int, vector<ll>, vector<ll>, vector<int>>> tests;
    tests.reserve(want_t);

    ll sum_n = 0;

    while ((int) tests.size() < want_t && sum_n < constants::SUM_N_LIMIT) {
        int n = rnd.next(min_n, max_n);
        if (sum_n + n > constants::SUM_N_LIMIT) break;
        int k_cap = min(n, min(kmax_opt, (int) constants::MAX_M));
        int k = rnd.next(1, k_cap);

        vector<int> xs;
        if (k == 1) {
            xs = {1};
        } else {
            int s = rnd.next(k, n);
            int rem = s - 1;
            auto parts = split_positive_sum(k - 1, rem);
            xs.reserve(k);
            xs.push_back(1);
            xs.insert(xs.end(), parts.begin(), parts.end());
        }

        vector<ll> X(n), Y(n);
        for (int i = 0; i < n; ++i) {
            X[i] = rnd.next(-coord_lim, coord_lim);
            Y[i] = rnd.next(-coord_lim, coord_lim);
        }

        tests.emplace_back(n, k, X, Y, xs);
        sum_n += n;
    }

    cout << tests.size() << "\n";
    for (auto &t: tests) {
        int n, k;
        vector<ll> X, Y;
        vector<int> xs;
        tie(n, k, X, Y, xs) = t;
        cout << n << " " << k << "\n";
        for (int i = 0; i < n; ++i) {
            if (i) cout << ' ';
            cout << X[i];
        }
        cout << "\n";
        for (int i = 0; i < n; ++i) {
            if (i) cout << ' ';
            cout << Y[i];
        }
        cout << "\n";
        for (int i = 0; i < (int) xs.size(); ++i) {
            if (i) cout << ' ';
            cout << xs[i];
        }
        cout << "\n";
    }
    return 0;
}
