/*
Author: @doreshnikov
Created on: 30.10.2024/17:27
*/

#include <vector>
#include <iostream>
#include <algorithm>
#include <unordered_set>
#include <array>

using namespace std;

typedef long long ll;
typedef unsigned long long ull;
typedef unsigned int uint;

void mcin() {}

template<typename T, typename ...Tail>
void mcin(T &&arg, Tail &&...args) {
    cin >> arg;
    mcin(args...);
}

#define in(type, ...) type __VA_ARGS__; mcin(__VA_ARGS__);
#define all(c) c.begin(), c.end()

template<typename T>
ostream &operator<<(ostream &out, vector<T> const &v) {
    out << v.size() << '\n';
    for (auto vi : v) {
        out << vi << ' ';
    }
    return out;
}

struct key {
    int id;
    int a, b, c;

    int left_side() const { return c + b; }
    int right_side() const { return a - c; }
    int min_side() const { return min(left_side(), right_side()); }
    int max_margin() const { return a - min_side(); }
};

int n, w;
vector<key> keys;
vector<int> pref_max_1, pref_max_2, suf_min_1, suf_min_2;

pair<key, bool> fallback_find_one() {
    auto min_b = *min_element(all(keys), [](key const &k1, key const &k2) -> bool {
        if (k1.b != k2.b) return k1.b < k2.b;
        return k1.id < k2.id;
    });
    if (min_b.b <= w) {
        return {min_b, true};
    }
    return {key{}, false};
}

vector<key> fallback_find_two() {
    if (n < 2) return {};

    auto k1 = keys[suf_min_1[0]];
    auto k2 = keys[suf_min_2[0]];
    if (k1.min_side() + k2.min_side() <= w) {
        return {k1, k2};
    }
    return {};
}

vector<key> try_replace(vector<key> answer, ll total, int k, int later_idx, int next_option, vector<pair<int, int>> const &args) {
    auto replace_one = [&](int ans_pos, int key_pos) {
        if (ans_pos == 0 || ans_pos == answer.size() - 1) {
            total -= answer[ans_pos].min_side();
            total += keys[key_pos].min_side();
        } else {
            total -= answer[ans_pos].a;
            total += keys[key_pos].a;
        }
        answer[ans_pos] = keys[key_pos];
    };

    // first replace
    for (auto [ans_pos, key_pos] : args) {
        replace_one(ans_pos, key_pos);
    }
    if (total <= w) {
        return answer;
    }

    // maybe try once again
    if (pref_max_2[k] == -1) return {};
    replace_one(later_idx, pref_max_2[k]);
    replace_one(pref_max_2[k] + 1, next_option);
    if (total <= w) {
        return answer;
    }

    return {};
}

// exactly k in the middle plus one on each side
vector<key> check_k_middle(int k, vector<ll> const &pref_a) {
    vector<key> answer;
    answer.push_back(keys[suf_min_1[k]]);
    for (int i = 0; i < k; i++) answer.push_back(keys[i]);
    answer.push_back(keys[suf_min_2[k]]);

    ll total = pref_a[k] + keys[suf_min_1[k]].min_side() + keys[suf_min_2[k]].min_side();
    if (total <= w) {
        return answer;
    }

    {
        int next_option = k, final_option = k + 1;
        if (suf_min_2[k] == k) swap(next_option, final_option);
        if (next_option < n) {
            auto attempt = try_replace(answer, total, k, answer.size() - 1, final_option, {{0, pref_max_1[k]}, {pref_max_1[k] + 1, next_option}});
            if (!attempt.empty()) return attempt;
        }
    }
    
    {
        int next_option = k, final_option = k + 1;
        if (suf_min_1[k] == k) swap(next_option, final_option);
        if (next_option < n) {
            auto attempt = try_replace(answer, total, k, 0, final_option, {{answer.size() - 1, pref_max_1[k]}, {pref_max_1[k] + 1, next_option}});
            if (!attempt.empty()) return attempt;
        }
    }
        
    return {};
}

vector<key> find_three_plus() {
    if (n < 3) return {};
    
    vector<ll> pref_a(n + 1);
    for (int i = 0; i < n; i++) {
        pref_a[i + 1] = pref_a[i] + keys[i].a;
    }
    int k = 0;
    while (k < n && pref_a[k + 1] <= w) {
        k++;
    }
    // from this point onward the answer is in [k, k + 2]

    if (k == n) return keys; // all fit
    if (k == 0) return {}; // switch to fallback_find_two

    for (int t = k; t >= k - 2; t--) {
        if (t + 2 > n) continue;
        if (t < 1) break;
        auto answer = check_k_middle(t, pref_a);
        if (!answer.empty()) {
            return answer;
        }
    }

    return {};
}

void print_answer(vector<key> const &answer) {
    cout << answer.size() << '\n';
    for (int i = 0; i < answer.size(); i++) {
        int id = answer[i].id;
        if (i == 0 && answer[i].min_side() == answer[i].left_side()) {
            id *= -1;
        }
        if (i == answer.size() - 1 && answer[i].min_side() == answer[i].right_side()) {
            id *= -1;
        }
        cout << id << ' ';
    }
    cout << '\n';
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    cin >> n >> w;
    keys.resize(n);
    for (int i = 0; i < n; i++) {
        cin >> keys[i].a >> keys[i].b >> keys[i].c;
        keys[i].id = i + 1;
    }
    
    sort(all(keys), [](const key &k1, const key &k2) -> bool {
        if (k1.a != k2.a) return k1.a < k2.a;
        return k1.max_margin() < k2.max_margin();
    });

    pref_max_1.resize(n + 1, -1);
    pref_max_2.resize(n + 1, -1);
    suf_min_1.resize(n + 1, -1);
    suf_min_2.resize(n + 1, -1);

    for (int i = 0; i < n; i++) {
        pref_max_1[i + 1] = pref_max_1[i];
        pref_max_2[i + 1] = pref_max_2[i];
        
        auto margin = keys[i].max_margin();
        if (pref_max_1[i] == -1 || margin > keys[pref_max_1[i]].max_margin()) {
            pref_max_2[i + 1] = pref_max_1[i];
            pref_max_1[i + 1] = i;
        } else if (pref_max_2[i] == -1 || margin > keys[pref_max_2[i]].max_margin()) {
            pref_max_2[i + 1] = i;
        }

        suf_min_1[n - i - 1] = suf_min_1[n - i];
        suf_min_2[n - i - 1] = suf_min_2[n - i];
        
        auto side = keys[n - i - 1].min_side();
        if (suf_min_1[n - i] == -1 || side < keys[suf_min_1[n - i]].min_side()) {
            suf_min_2[n - i - 1] = suf_min_1[n - i];
            suf_min_1[n - i - 1] = n - i - 1;
        } else if (suf_min_2[n - i] == -1 || side < keys[suf_min_2[n - i]].min_side()) {
            suf_min_2[n - i - 1] = n - i - 1;
        }
    }

    auto answer = find_three_plus();
    if (!answer.empty()) {
        print_answer(answer);
        return 0;
    }
    answer = fallback_find_two();
    if (!answer.empty()) {
        print_answer(answer);
        return 0;
    }
    auto [key, ok] = fallback_find_one();
    if (ok) {
        cout << "1\n" << key.id << '\n';
        return 0;
    }

    cout << "0\n\n";

}
