#include "bits/stdc++.h"

using namespace std;

struct info {
    int a, b, c, i;
};

vector<int> soll(int p1, int p2, vector<info>& v, int w) {
    int l = 0;
    int r = 0;

    for (int i = 0; i < v.size(); ++i) {
        if (v[i].i == p1) {
            int a = v[i].a - v[i].c;
            int b = v[i].b + v[i].c;

            if (a < b) l = p1 + 1;
            else l = -p1 - 1;

            w -= min(a, b);
        }

        if (v[i].i == p2) {
            int a = v[i].b + v[i].c;
            int b = v[i].a - v[i].c;

            if (a < b) r = p2 + 1;
            else r = -p2 - 1;

            w -= min(a, b);
        }
    }

    if (w < 0) return {};

    vector<int> ans;
    ans.push_back(l);
    for (int i = 0; i < v.size(); ++i) {
        if (v[i].i == p1 || v[i].i == p2) continue;
        w -= v[i].a;
        if (w < 0) break;
        ans.push_back(v[i].i + 1);
    }
    ans.push_back(r);

    return ans;
}

vector<int> sol(vector<info>& v, int n, int w) {
    sort(v.begin(), v.end(), [](info a, info b) { return a.a < b.a; });

    int i, cs = 0;
    for (i = 0; i < n; ++i) {
        cs += v[i].a;
        if (cs > w) break;
    }

    vector<info> a(v.begin(), v.begin() + i); // ok
    vector<info> b(v.begin(), v.begin() + i); // inverse
    vector<info> c(v.begin() + i, v.end());
    vector<info> d(v.begin() + i, v.end());

    if (a.size() == 0) return {};
    if (c.size() == 0) {
        vector<int> ans(n);
        iota(ans.begin(), ans.end(), 1);
        return ans;
    }

    sort(a.begin(), a.end(), [](info a, info b) { return a.a - a.c < b.a - b.c; });
    sort(b.begin(), b.end(), [](info a, info b) { return a.b + a.c < b.b + b.c; });

    sort(c.begin(), c.end(), [](info a, info b) { return a.a - a.c < b.a - b.c; });
    sort(d.begin(), d.end(), [](info a, info b) { return a.b + a.c < b.b + b.c; });

    vector<int> pos;
    for (int i = 0; i < min<int>(3, a.size()); ++i) pos.push_back(a[i].i);
    for (int i = 0; i < min<int>(3, b.size()); ++i) pos.push_back(b[i].i);
    for (int i = 0; i < min<int>(3, c.size()); ++i) pos.push_back(c[i].i);
    for (int i = 0; i < min<int>(3, d.size()); ++i) pos.push_back(d[i].i);

    sort(pos.begin(), pos.end());
    pos.resize(unique(pos.begin(), pos.end()) - pos.begin());

    vector<int> ans;
    for (int i = 0; i < pos.size(); ++i) {
        for (int j = i + 1; j < pos.size(); ++j) {
            vector<int> tmp = soll(pos[i], pos[j], v, w);
            if (tmp.size() > ans.size()) ans = tmp;
        }
    }

    return ans;
}

int main() {
    int n, w; cin >> n >> w;
    vector<info> v(n);

    bool ok = 0;
    int c = -1;
    for (int i = 0; i < n; ++i) {
        cin >> v[i].a >> v[i].b >> v[i].c;
        v[i].i = i;
        if (v[i].b <= w) {
            ok = 1;
            c = i;
        }
    }

    if (ok) {
        vector<int> ans = sol(v, n, w);
        if (ans.size() < 2) {
            cout << "1\n" << c + 1;
        } else {
            cout << ans.size() << "\n";
            for (int i = 0; i < ans.size(); ++i) cout << ans[i] << " ";
        }
    } else {
        cout << "0";
    }
}
