#include "bits/stdc++.h"

using namespace std;

#define ll long long

ll n, k;

struct node {
    node *left = nullptr, *right = nullptr;
    ll sum = 0;
    bool inv = 0;
};

void inv(node *root, ll len) {
    root->sum = ((1ll << k) - 1ll) * len - root->sum;
    root->inv ^= 1;
}

void push(node *root, ll len) {
    if (root->inv) {
        if (root->left == nullptr) {
            root->inv = 0;
            return;
        }

        inv(root->left, len / 2);
        inv(root->right, len - len / 2);

        root->inv = 0;
    }
}

void inverse(ll tl, ll tr, int l, int r, node *root) {
    if (tr <= l || r <= tl) return;
    if (l <= tl && tr <= r) {
        inv(root, tr - tl);
        return;
    }

    push(root, tr - tl);

    ll t = (tl + tr) / 2;
    inverse(tl, t, l, r, root->left);
    inverse(t, tr, l, r, root->right);

    root->sum = root->left->sum + root->right->sum;
}

void sett(int tl, int tr, int i, node *root, ll val) {
    if (tr - tl == 1) {
        root->sum = val;
        return;
    }

    push(root, tr - tl);

    int t = (tl + tr) / 2;
    if (i < t) sett(tl, t, i, root->left, val);
    else sett(t, tr, i, root->right, val);

    root->sum = root->left->sum + root->right->sum;
}

ll sum(int tl, int tr, int l, int r, node *root) {
    if (tr <= l || r <= tl) return 0;
    if (l <= tl && tr <= r) {
        return root->sum;
    }

    push(root, tr - tl);

    int t = (tl + tr) / 2;
    return sum(tl, t, l, r, root->left) + sum(t, tr, l, r, root->right);
}

void build(int l, int r, node *root, vector<int>& v) {
    if (r - l == 1) {
        root->sum = v[l];
        return;
    }

    root->left = new node();
    root->right = new node();

    int t = (l + r) / 2;
    build(l, t, root->left, v);
    build(t, r, root->right, v);

    root->sum = root->left->sum + root->right->sum;
}

node *root = new node();

void inverse(int l, int r) {
    inverse(0, n, l, r, root);
}

void sett(int i, ll val) {
    sett(0, n, i, root, val);
}

ll sum(int l, int r) {
    return sum(0, n, l, r, root);
}

void build(vector<int>& v) {
    build(0, n, root, v);
}

int main() {
    cin >> n >> k;
    vector<int> v(n);
    for (int i = 0; i < v.size(); ++i) cin >> v[i];
    build(v);

    int q; cin >> q;
    while (q--) {
        int t; cin >> t;

        if (t == 1) {
            int i, x; cin >> i >> x;
            --i;
            sett(i, x);
        } else if (t == 2) {
            int l, r; cin >> l >> r;
            --l;
            inverse(l, r);
        } else {
            int l, r; cin >> l >> r;
            --l;
            cout << sum(l, r) << "\n";
        }
    }
}
