#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>

using namespace std;

template<typename T>
istream &operator>>(istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) in >> a[i];
    return in;
}

struct dsu {
    int n;
    vector<int> par;
    vector<int> rank;

    dsu() = default;

    dsu(int n) : n(n), par(vector<int>(n)), rank(vector<int>(n)) {
        std::iota(par.begin(), par.end(), 0);
    }

    int get_par(int v) {
        if (v == par[v]) {
            return v;
        }
        return par[v] = get_par(par[v]);
    }

    bool check(int u, int v) {
        return get_par(u) == get_par(v);
    }

    void unite(int u, int v) {
        u = get_par(u);
        v = get_par(v);
        if (u != v) {
            if (rank[u] > rank[v]) {
                std::swap(u, v);
            } else if (rank[u] == rank[v]) {
                rank[v]++;
            }
            par[u] = v;
        }
    }
};

using graph = vector<vector<int>>;

void solve() {
    int n, m, q;
    cin >> n >> m >> q;

    vector<int> xs(n), ys(n);
    cin >> xs >> ys;
    graph g(n);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        g[u].push_back(v);
        g[v].push_back(u);
    }

    vector<int> cuts(q);
    cin >> cuts;

    vector<int> ord(n);
    iota(ord.begin(), ord.end(), 0);
    sort(ord.begin(), ord.end(), [&](int a, int b) {
        if (xs[a] != xs[b]) return xs[a] < xs[b];
        return a < b;
    });

    vector<int> uniq = cuts;
    sort(uniq.begin(), uniq.end());
    uniq.resize(unique(uniq.begin(), uniq.end()) - uniq.begin());

    unordered_map<int, int> left;

    dsu dL(n);
    vector<bool> usedl(n);
    int compsL = 0, ptrL = 0;

    for (int k: uniq) {
        while (ptrL < n && xs[ord[ptrL]] < k) {
            int u = ord[ptrL++];
            if (usedl[u]) continue;
            usedl[u] = true;
            ++compsL;
            for (int v: g[u])
                if (usedl[v]) {
                    if (!dL.check(u, v)) {
                        dL.unite(u, v);
                        --compsL;
                    }
                }
        }
        left[k] = compsL;
    }

    unordered_map<int, int> right;

    dsu dR(n);
    vector<bool> usedr(n);
    int compsR = 0, ptrR = n - 1;

    for (int i = (int) uniq.size() - 1; i >= 0; --i) {
        int k = uniq[i];
        while (ptrR >= 0 && xs[ord[ptrR]] > k) {
            int u = ord[ptrR--];
            if (usedr[u]) continue;
            usedr[u] = true;
            ++compsR;
            for (int v: g[u])
                if (usedr[v]) {
                    if (!dR.check(u, v)) {
                        dR.unite(u, v);
                        --compsR;
                    }
                }
        }
        right[k] = compsR;
    }

    for (int i = 0; i < q; ++i) {
        int k = cuts[i];
        int ans = left[k] + right[k];
        cout << ans << ' ';
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin >> tests;
    while (tests--) {
        solve();
        cout << '\n';
    }
}
