#include "testlib.h"
#include "constants.h"

using ll = long long;

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int t = inf.readInt(1, constants::MAX_T, "t");
    inf.readEoln();

    ll sum_nq = 0;
    ll sum_r = 0;

    for (int tc = 1; tc <= t; ++tc) {
        setTestCase(tc);

        int n = inf.readInt(1, constants::MAX_N, "n");
        inf.readSpace();
        int q = inf.readInt(1, constants::MAX_Q, "q");
        inf.readEoln();

        sum_nq += 1ll * n * q;
        ensuref(sum_nq <= constants::SUM_NQ_LIMIT,
                "sum of nq over all datasets must be <= %lld, got %lld after dataset #%d",
                constants::SUM_NQ_LIMIT, sum_nq, tc);

        inf.readInts(n, -constants::MAX_COORD, constants::MAX_COORD, "~x~");
        inf.readEoln();

        for (int qi = 1; qi <= q; ++qi) {
            int k = inf.readInt(1, constants::MAX_K, "k");
            inf.readSpace();
            int r = inf.readInt(0, k, "r");

            for (int i = 1; i <= r; ++i) {
                inf.readSpace();
                inf.readInt(-constants::MAX_COORD, constants::MAX_COORD, "~a~");
            }
            inf.readEoln();

            sum_r += r;
            ensuref(sum_r <= constants::SUM_R_LIMIT,
                    "sum of r over all datasets must be <= %lld, got %lld after (dataset #%d, query #%d)",
                    constants::SUM_R_LIMIT, sum_r, tc, qi);
        }
    }

    inf.readEof();
}
