#include "testlib.h"
#include "constants.h"
#include <bits/stdc++.h>

using namespace std;

using ll = long long;

template<typename T>
T get_opt(const string &key, const T &def) {
    return has_opt(key) ? opt<T>(key) : def;
}

static vector<int> split_positive_sum(int parts, int sum) {
    if (parts <= 1) return {sum};
    vector<int> cuts;
    cuts.reserve(parts - 1);
    set<int> used;
    while ((int) used.size() < parts - 1) {
        int x = rnd.next(1, sum - 1);
        used.insert(x);
    }
    for (int x: used) cuts.push_back(x);
    sort(cuts.begin(), cuts.end());
    vector<int> res;
    res.reserve(parts);
    int prev = 0;
    for (int c: cuts) {
        res.push_back(c - prev);
        prev = c;
    }
    res.push_back(sum - prev);
    return res;
}

static inline void add_point(vector<ll> &X, vector<ll> &Y, ll x, ll y, ll LIM) {
    x = max(-LIM, min(LIM, x));
    y = max(-LIM, min(LIM, y));
    X.push_back(x);
    Y.push_back(y);
}

static void shuffle_points(vector<ll> &X, vector<ll> &Y) {
    int n = (int) X.size();
    vector<int> p(n);
    iota(p.begin(), p.end(), 0);
    shuffle(p.begin(), p.end());
    vector<ll> nX(n), nY(n);
    for (int i = 0; i < n; ++i) {
        nX[i] = X[p[i]];
        nY[i] = Y[p[i]];
    }
    X.swap(nX);
    Y.swap(nY);
}

static void build_elliptic_case(const vector<int> &xs, int n, ll LIM, vector<ll> &X, vector<ll> &Y) {
    X.clear();
    Y.clear();

    int k = (int) xs.size();
    int needLevels = max(0, k - 1);

    ll L = max<ll>(2, min<ll>(LIM / 3, 1'000'000));
    for (int it = 0; it < 3; ++it) {
        ll maxD = min(LIM, LIM - L);
        if (maxD >= needLevels + 5) break;
        L = max<ll>(2, L / 2);
    }
    if (L >= LIM) L = max<ll>(2, LIM - 10);

    ll maxD = min(LIM, LIM - L);
    if (maxD < needLevels) {
        L = max<ll>(2, LIM / 4);
        maxD = min(LIM, LIM - L);
    }

    add_point(X, Y, L, 0, LIM);

    ll d = 0;
    for (int j = 1; j < k; ++j) {
        int m = xs[j];
        int remLevels = (k - 1) - j;
        ll leftRoom = maxD - d;
        ll maxStep = max<ll>(1, leftRoom - remLevels);
        ll step = rnd.next(1, (int) maxStep);
        d += step;

        int leftCnt = rnd.next(0, m);
        int rightCnt = m - leftCnt;
        for (int i = 0; i < leftCnt; ++i) add_point(X, Y, -d, 0, LIM);
        for (int i = 0; i < rightCnt; ++i) add_point(X, Y, L + d, 0, LIM);
    }

    auto forbidden = [&](ll x, ll y) -> bool {
        if (y != 0) return false;
        if (x == L) return true;
        if (x < 0) {
            ll dd = -x;
            return (1 <= dd && dd <= maxD);
        } else {
            ll dd = x - L;
            return (1 <= dd && dd <= maxD);
        }
    };

    while ((int) X.size() < n) {
        ll rx = rnd.next(-LIM, LIM);
        ll ry = rnd.next(-LIM, LIM);
        if (forbidden(rx, ry)) continue;
        add_point(X, Y, rx, ry, LIM);
    }

    shuffle_points(X, Y);
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    const int want_t = get_opt<int>("t", (int) constants::MAX_T);
    const int min_n = get_opt<int>("min_n", 1);
    const int max_n = get_opt<int>("max_n", (int) constants::MAX_N);
    const ll LIM = get_opt<ll>("coord", (ll) constants::MAX_COORD);
    const int kmax_opt = get_opt<int>("kmax", (int) constants::MAX_M);

    vector<tuple<int, int, vector<ll>, vector<ll>, vector<int>>> tests;
    tests.reserve(want_t);

    long long budget = constants::SUM_N_LIMIT;

    while ((int) tests.size() < want_t && budget > 0) {
        int n_hi = min<int>(max_n, (int) budget);
        if (min_n > n_hi) break;
        int n = rnd.next(min_n, n_hi);

        int k_cap = min(n, min(kmax_opt, (int) constants::MAX_M));
        int k = rnd.next(1, k_cap);

        vector<int> xs;
        if (k == 1) {
            xs = {1};
        } else {
            int s = rnd.next(k, n);
            int rem = s - 1;
            auto parts = split_positive_sum(k - 1, rem);
            xs.reserve(k);
            xs.push_back(1);
            xs.insert(xs.end(), parts.begin(), parts.end());
        }

        vector<ll> X, Y;
        int s = 0;
        for (int v: xs) s += v;
        build_elliptic_case(xs, n, LIM, X, Y);

        if ((int) X.size() > n) {
            X.resize(n);
            Y.resize(n);
        }
        while ((int) X.size() < n) {
            add_point(X, Y, rnd.next(-LIM, LIM), rnd.next(-LIM, LIM), LIM);
        }

        tests.emplace_back(n, k, X, Y, xs);
        budget -= n;
    }

    cout << tests.size() << "\n";
    for (auto &t: tests) {
        int n, k;
        vector<ll> X, Y;
        vector<int> xs;
        tie(n, k, X, Y, xs) = t;
        cout << n << " " << k << "\n";
        for (int i = 0; i < n; ++i) {
            if (i) cout << ' ';
            cout << X[i];
        }
        cout << "\n";
        for (int i = 0; i < n; ++i) {
            if (i) cout << ' ';
            cout << Y[i];
        }
        cout << "\n";
        for (int i = 0; i < (int) xs.size(); ++i) {
            if (i) cout << ' ';
            cout << xs[i];
        }
        cout << "\n";
    }
}
