#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>
#include <cmath>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

template<typename T, typename V = T>
using pair = std::pair<T, V>;

using ll = long long;
using ull = unsigned long long;
using dl = long double;

#define all(x) (x).begin(), (x).end()

template<typename T>
std::ostream &operator<<(std::ostream &out, const pair<T, T> &a) {
    out << '(' << a.first << ' ' << a.second << ')';
    return out;
}

template<typename T, typename V>
std::istream &operator>>(std::istream &in, pair<T, V> &a) {
    in >> a.first >> a.second;
    return in;
}

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

struct int_mod;

template<typename T>
std::ostream &operator<<(std::ostream &out, const vector<T> &container) {
    char separator = (std::is_arithmetic_v<T> || std::is_same_v<T, int_mod>)
                     ? ' '
                     : '\n';

    for (const auto &i: container) {
        out << i << separator;
    }
    return out;
}

template<typename T>
bool mini(T &a, const T &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T &a, const T &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
T binpow(const T &a, ll exp) {
    T res(1);
    T base = a;
    while (exp > 0) {
        if (exp & 1)
            res *= base;
        base *= base;
        exp /= 2;
    }
    return res;
}

struct int_mod {
    static const int MOD = 1e9 + 7;
private:
    int val;

public:
    int_mod() : val(0) {}

    int_mod(int x) {
        val = (x % MOD + MOD) % MOD;
    }

    int_mod(ll x) {
        val = (int) ((x % MOD + MOD) % MOD);
    }

    operator int() const {
        return val;
    }

    int_mod &operator+=(const int_mod &other) {
        val += other.val;
        if (val >= MOD)
            val -= MOD;
        return *this;
    }

    int_mod &operator-=(const int_mod &other) {
        val -= other.val;
        if (val < 0)
            val += MOD;
        return *this;
    }

    int_mod &operator*=(const int_mod &other) {
        val = static_cast<int>(static_cast<long long>(val) * other.val % MOD);
        return *this;
    }

    int_mod &operator/=(const int_mod &other) {
        return *this *= other.inv();
    }

    int_mod inv() const {
        return binpow(*this, MOD - 2);
    }

    friend int_mod operator+(int_mod a, const int_mod &b) {
        a += b;
        return a;
    }

    friend int_mod operator+(int_mod a, int b) {
        a += b;
        return a;
    }

    friend int_mod operator-(int_mod a, const int_mod &b) {
        a -= b;
        return a;
    }

    friend int_mod operator-(int_mod a, int b) {
        a -= b;
        return a;
    }

    friend int_mod operator*(int_mod a, const int_mod &b) {
        a *= b;
        return a;
    }

    friend int_mod operator*(int_mod a, int b) {
        a *= b;
        return a;
    }

    friend int_mod operator/(int_mod a, const int_mod &b) {
        a /= b;
        return a;
    }

    friend int_mod operator/(int_mod a, int_mod b) {
        a /= b;
        return a;
    }

    friend std::ostream &operator<<(std::ostream &os, const int_mod &m) {
        return os << m.val;
    }

    friend std::istream &operator>>(std::istream &is, int_mod &m) {
        int x;
        is >> x;
        m = int_mod(x);
        return is;
    }
};

const dl eps = 1e-8;

bool eq(dl x, dl y) {
    return abs(x - y) < eps;
}

vector<int> get_data(const vector<dl> &data, dl base) {
    vector<int> got;
    int j = 0;
    while (j < data.size() && eq(data[j], base)) j++;
    while (j < data.size()) {
        int l = j + 1;
        while (l < data.size() && eq(data[l], data[j])) ++l;
        got.push_back(l - j);
        j = l;
    }
    return got;
}

const int MAXN = 1010;

int_mod fact[MAXN];
int_mod inv_fact[MAXN];

void init() {
    fact[0] = 1;
    for (int i = 1; i < MAXN; i++) fact[i] = fact[i - 1] * i;
    inv_fact[MAXN - 1] = fact[MAXN - 1].inv();
    for (int i = MAXN - 2; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1);
    }
}

int_mod calc_c(int n, int k) {
    if (k < 0 || k > n) return 0;
    return fact[n] * inv_fact[k] * inv_fact[n - k];
}

int_mod calc(const vector<int> &a, const vector<int> &b) {
    int K = (int) b.size();
    vector<int_mod> dp(K + 1, 0);
    dp[0] = 1;
    for (int c: a) {
        for (int r = K - 1; r >= 0; --r) {
            if (c >= b[r]) dp[r + 1] += dp[r] * calc_c(c, b[r]);
        }
    }
    return dp[K];
}

void solve() {
    int n, k;
    cin >> n >> k;

    vector<ll> xs(n), ys(n);
    cin >> xs >> ys;

    vector<int> groups(k);
    cin >> groups;

    groups.erase(groups.begin());

    int_mod ans = 0;

    for (int i = 0; i < n; i++) {
        vector<dl> dist;
        for (int j = 0; j < n; j++) {
            if (j == i) continue;
            dist.emplace_back(hypotl(xs[i] - xs[j], ys[i] - ys[j]) +
                              hypotl(xs[j], ys[j]));
        }
        sort(all(dist));
        dl base = hypotl(xs[i], ys[i]);
        auto z = get_data(dist, base);
        ans += calc(z, groups);

    }
    cout << ans;
}

signed main() {
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests = 1;
    cin >> tests;

    init();

    while (tests--) {
        solve();
        cout << '\n';
    }
}

