//
// Created by Daniil Oreshnikov on 02.11.2024.
//

#include <iostream>
#include <vector>
#include "testlib.h"

using namespace std;

struct key {
    int a, b, c;

    int left() const {
        return b + c;
    }

    int right() const {
        return a - c;
    }
};

int n, w;
vector <key> keys;

inline int check(InStream &in) {
    int k = in.readInt(0, n, "k");
    vector<int> used(n);
    vector <pair<int, bool>> seq;

    for (int i = 0; i < k; i++) {
        int id = in.readInt(-n, n, format("k_%d", i + 1));
        in.ensuref(id != 0, "key id should not be 0");

        bool rev = false;
        if (id < 0) {
            id = -id;
            rev = true;
        }
        id--;
        seq.emplace_back(id, rev);

        in.ensuref(!used[id], "key used twice");
        used[id] = 1;
    }

    if (k == 0) return 0;
    if (k == 1) {
        in.ensuref(keys[seq[0].first].b <= w, "key sequence doesn't fit");
        return 1;
    }

    long long len = 0;
    for (int i = 1; i < seq.size() - 1; i++) {
        len += keys[seq[i].first].a;
    }
    len += seq[0].second ? keys[seq[0].first].left() : keys[seq[0].first].right();
    len += seq.back().second ? keys[seq.back().first].right() : keys[seq.back().first].left();
    in.ensuref(len <= (long long) w, "key sequence doesn't fit");

    return k;
}

int main(int argc, char *argv[]) {

    registerTestlibCmd(argc, argv);

    n = inf.readInt();
    w = inf.readInt();
    keys.resize(n);
    for (int i = 0; i < n; i++) {
        keys[i] = {inf.readInt(), inf.readInt(), inf.readInt()};
    }

    int ja = check(ans), pa = check(ouf);
    if (ja < pa) quitf(_fail, "participant found a better answer");
    if (pa < ja) quitf(_wa, "jury has a better answer");
    quitf(_ok, "answers match");

}
