/*
Author: @doreshnikov
Created on: 30.10.2024/17:27
*/

#include <vector>
#include <iostream>
#include <algorithm>
#include <unordered_set>
#include <array>

using namespace std;

typedef unsigned long long ull;
typedef unsigned int uint;

void mcin() {}

template<typename T, typename ...Tail>
void mcin(T &&arg, Tail &&...args) {
    cin >> arg;
    mcin(args...);
}

#define in(type, ...) type __VA_ARGS__; mcin(__VA_ARGS__);
#define all(c) c.begin(), c.end()

int const INF = 1000'000'000;

struct key {
    int id;
    int a, b, c;

    int left() const { return b + c; }
    int right() const { return a - c; }
    int min_side() const { return min(left(), right()); }
    int max_margin() const { return max(c, a - b - c); }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    in(int, n, w)
    vector<key> keys(n);
    for (int i = 0; i < n; i++) {
        cin >> keys[i].a >> keys[i].b >> keys[i].c;
        keys[i].id = i;
    }

    // базовые случаи
    int ans = 0;
    vector<int> best_set;

    if (n > 0) {
        int min_b = keys[0].b;
        int idb = 0;
        for (int i = 1; i < n; ++i) {
            if (keys[i].b < min_b) { min_b = keys[i].b; idb = i; }
        }
        if ((long long)min_b <= (long long)w) {
            ans = 1;
            best_set = {idb + 1};
        }
    }
    if (n < 2) {
        cout << ans << "\n";
        for (int i : best_set) cout << i << " ";
        if (!best_set.empty()) cout << "\n";
        return 0;
    }

    // сортируем по a
    vector<key> v = keys;
    sort(all(v), [](const key &k1, const key &k2) {
        if (k1.a != k2.a) return k1.a < k2.a;
        return k1.id < k2.id;
    });

    int N = n;
    const long long INF64 = (long long)4e18;

    vector<long long> prefA(N + 1, 0);
    for (int i = 1; i <= N; ++i) prefA[i] = prefA[i - 1] + (long long)v[i - 1].a;

    vector<array<long long, 2>> prefBestU(N + 1, {INF64, INF64});
    vector<array<int, 2>> prefIdxU(N + 1, {-1, -1});
    {
        long long b1 = INF64, b2 = INF64;
        int i1 = -1, i2 = -1;
        prefBestU[0] = {INF64, INF64};
        prefIdxU[0] = {-1, -1};
        for (int t = 1; t <= N; ++t) {
            long long s = v[t - 1].min_side();
            long long u = s - (long long)v[t - 1].a;
            if (u < b1) { b2 = b1; i2 = i1; b1 = u; i1 = t - 1; }
            else if (u < b2) { b2 = u; i2 = t - 1; }
            prefBestU[t] = {b1, b2};
            prefIdxU[t] = {i1, i2};
        }
    }

    vector<array<long long, 2>> suffBestS(N + 1, {INF64, INF64});
    vector<array<int, 2>> suffIdxS(N + 1, {-1, -1});
    {
        long long b1 = INF64, b2 = INF64;
        int i1 = -1, i2 = -1;
        suffBestS[N] = {INF64, INF64};
        suffIdxS[N] = {-1, -1};
        for (int t = N - 1; t >= 0; --t) {
            long long s = v[t].min_side();
            if (s < b1) { b2 = b1; i2 = i1; b1 = s; i1 = t; }
            else if (s < b2) { b2 = s; i2 = t; }
            suffBestS[t] = {b1, b2};
            suffIdxS[t] = {i1, i2};
        }
    }

    auto getA = [&](int idx) -> long long {
        if (idx <= 0 || idx > N) return INF64;
        return (long long)v[idx - 1].a;
    };

    long long best_width = INF64;
    int best_case = -1;
    int best_t = -1;
    array<int, 2> best_ends = {-1, -1};

    for (int t = 0; t <= N; ++t) {
        int k = t + 2;
        if (k > N) break;
        long long S_t = prefA[t];
        long long best = INF64;
        int case_id = -1;
        array<int, 2> ends = {-1, -1};

        // A: оба конца вне топ-t
        if (N - t >= 2) {
            auto [s1, s2] = suffBestS[t];
            if (s2 < INF64) {
                long long cur = S_t + s1 + s2;
                if (cur < best) {
                    best = cur; case_id = 0; ends = suffIdxS[t];
                }
            }
        }

        // B: один внутри, второй снаружи
        if (t >= 1 && N - t >= 1) {
            long long a_t1 = getA(t + 1);
            auto [u1, _] = prefBestU[t];
            auto [ui1, _ui2] = prefIdxU[t];
            auto [s1, _s2] = suffBestS[t];
            auto [si1, _si2] = suffIdxS[t];
            if (u1 < INF64 && s1 < INF64) {
                long long cur = S_t + a_t1 + u1 + s1;
                if (cur < best) {
                    best = cur; case_id = 1; ends = {ui1, si1};
                }
            }
        }

        // C: оба конца внутри
        if (t >= 2) {
            long long a_t1 = getA(t + 1), a_t2 = getA(t + 2);
            auto [u1, u2] = prefBestU[t];
            auto [ui1, ui2] = prefIdxU[t];
            if (u2 < INF64) {
                long long cur = S_t + a_t1 + a_t2 + u1 + u2;
                if (cur < best) {
                    best = cur; case_id = 2; ends = {ui1, ui2};
                }
            }
        }

        if (best <= (long long)w && k > ans) {
            ans = k;
            best_t = t;
            best_case = case_id;
            best_ends = ends;
            best_width = best;
        }
    }

    vector<int> chosen;

    if (ans == 1) {
        chosen = best_set;
    } else if (ans >= 2 && best_t >= 0) {
        int t = best_t;
        int k = ans;
        // центр — первые t (по a)
        vector<int> center;
        for (int i = 0; i < t; ++i) center.push_back(v[i].id + 1);
        vector<int> ends;
        if (best_case == 0) { // оба снаружи
            ends.push_back(v[best_ends[0]].id + 1);
            ends.push_back(v[best_ends[1]].id + 1);
        } else if (best_case == 1) { // один внутри, второй снаружи
            ends.push_back(v[best_ends[0]].id + 1);
            ends.push_back(v[best_ends[1]].id + 1);
            // один из концов забрался из центра => нужно добавить a_{t+1}
            if (t + 1 <= N) center.push_back(v[t].id + 1);
        } else if (best_case == 2) { // оба из центра
            ends.push_back(v[best_ends[0]].id + 1);
            ends.push_back(v[best_ends[1]].id + 1);
            if (t + 1 <= N) center.push_back(v[t].id + 1);
            if (t + 2 <= N) center.push_back(v[t + 1].id + 1);
        }

        // Объединяем
        unordered_set<int> used(ends.begin(), ends.end());
        for (int x : center)
            if (!used.count(x))
                chosen.push_back(x);
        for (int x : ends)
            chosen.push_back(x);
    }

    cout << ans << "\n";
    sort(all(chosen));
    for (int i : chosen) cout << i << " ";
    if (!chosen.empty()) cout << "\n";
    return 0;
}
