import java.util.*;
import java.io.*;

public final class XorPrefixSuffix {
    static class FastReader {
        private BufferedReader br;
        private StringTokenizer st;

        public FastReader() {
            br = new BufferedReader(new InputStreamReader(System.in));
            st = null;
        }

        private String next() {
            while (st == null || !st.hasMoreElements()) {
                try {
                st = new StringTokenizer(br.readLine());
                } catch (IOException e) {
                }                     
            }
            return st.nextToken();
        }

        public int nextInt() {
            return Integer.parseInt(next());
        }
    }


    public static void main(final String[] args) {
        FastReader reader = new FastReader();

        int n = reader.nextInt();
        int arr[] = new int[n];
        int xorall = 0;
        Map<Integer, Integer> m = new HashMap<>();

        for (int i = 0; i < n; i++) {
            arr[i] = reader.nextInt();
            xorall ^= arr[i];
            m.merge(arr[i], 1, Integer::sum);
        }

        int q = reader.nextInt();

        for (int i = 0; i < q; i++) {
            int k = reader.nextInt();

            if (k == 1) {
                int j = reader.nextInt();
                int v = reader.nextInt();
                
                m.merge(arr[j], -1, Integer::sum);
                xorall ^= arr[j];
                
                arr[j] = v;
                
                m.merge(arr[j], 1, Integer::sum);
                xorall ^= arr[j];
            } else {
                Integer data = m.get(xorall);
                if (data == null) {
                    System.out.println(0);
                } else {
                    System.out.println(data);
                }
            }
        }
    }
}