#include "testlib.h"
#include <iostream>
#include <set>
#include <vector>
#include <random>

using namespace std;

pair<int, pair<int, int>> extendedEuclid(int a, int b) {
    if (b == 0) {
        return { a, {1, 0} };
    }

    pair<int, pair<int, int>> ee = extendedEuclid(b, a % b);
    int gcd = ee.first;
    pair<int, int> coeffs = ee.second;

    int x1 = coeffs.first;
    int y1 = coeffs.second;

    int x = y1;
    int y = x1 - (a / b) * y1;

    return { gcd, {x, y} };
}

pair<int, int> getRandomPointOnLine(int A, int B, int C) {
    if (B == 0) {
        int x = -C / A;
        return { x, rnd.next(-1'000'000'000, 1'000'000'000) };
    }

    if (A == 0) {
        int y = -C / B;
        return { rnd.next(-1'000'000'000, 1'000'000'000), y };
    }

    pair<int, pair<int, int>> ee = extendedEuclid(A, B);
    int gcd = ee.first;
    pair<int, int> coeffs = ee.second;
    int x0 = coeffs.first;
    int y0 = coeffs.second;

    int scale = -C / gcd;
    x0 *= scale;
    y0 *= scale;

    int t = rnd.next(-100'000, 100'000);
    int x = x0 + (B / gcd) * t;
    int y = y0 - (A / gcd) * t;

    return { x, y };
}

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);

    int n = opt<int>(1);
    vector<vector<int>> queries;

    set<pair<int, int>> dots;
    set<vector<int>> lines;
    while (int(queries.size()) < n) {
        if (lines.empty()) {
            int A = rnd.next(-500, 500);
            int B = rnd.next(-500, 500);
            int g = extendedEuclid(abs(A), abs(B)).first;
            int C = rnd.next(-1'000'000, 1'000'000) * g;

            lines.insert({ A, B, C });
        }

        int type = rnd.next(1, 100);
        if (type < 80) {
            int ind = rnd.next(0, int(lines.size()) - 1);
            auto it = lines.begin();
            while (ind--) it++;
            int A = it->at(0), B = it->at(1), C = it->at(2);

            pair<int, int> d = getRandomPointOnLine(A, B, C);
            while (dots.find(d) != dots.end()) {
                d = getRandomPointOnLine(A, B, C);
            }
            queries.push_back({ 1, d.first, d.second });
            dots.insert(d);
        }
        else if (type < 85 && lines.size() < 5) {
            int A = rnd.next(-500, 500);
            int B = rnd.next(-500, 500);
            int g = extendedEuclid(abs(A), abs(B)).first;
            int C = rnd.next(-1'000'000, 1'000'000) * g;

            lines.insert({ A, B, C });
        }
        else if (lines.size() == 5 || type < 95) {
            int ind = rnd.next(0, int(lines.size()) - 1);
            auto it = lines.begin();
            while (ind--) it++;

            vector<pair<int, int>> toDel;
            int A = it->at(0), B = it->at(1), C = it->at(2);
            for (auto dit = dots.begin(); dit != dots.end(); dit++) {
                if (1ll * A * dit->first + 1ll * B * dit->second == -1ll * C) {
                    toDel.push_back({ dit->first, dit->second });
                }
            }
            for (pair<int, int> p : toDel) {
                dots.erase(p);
                queries.push_back({ -1, p.first, p.second });
                if (int(queries.size()) == n) break;
            }
            
            lines.erase(it);
        }
        else {
            if (dots.empty()) continue;
            int ind = rnd.next(0, int(dots.size()) - 1);
            auto it = dots.begin();
            while (ind--) it++;

            queries.push_back({ -1, it->first, it->second });
            dots.erase(it);
        }
    }

    cout << int(queries.size()) << endl;
    for (vector<int> x : queries) {
        if (x[0] == 1) cout << "+ ";
        else cout << "- ";

        cout << x[1] << ' ' << x[2] << endl;
    }
}
