#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <map>

using namespace std;
using ll = long long;

ll gcd(ll a, ll b) {
	if (b == 0) return a;
	return gcd(b, a % b);
}

vector<ll> f(ll x1, ll y1, ll x2, ll y2) {
	ll A = y1 - y2;
	ll B = x2 - x1;
	ll C = A * x1 + B * y1;

	if (A == 0 && B == 0) {
		return { 0, 0, 0 };
	}

	ll gcd_ = gcd(gcd(abs(A), abs(B)), abs(C));

	if (gcd != 0) {
		A /= gcd_;
		B /= gcd_;
		C /= gcd_;
	}

	if (A < 0) {
		A = -A;
		B = -B;
		C = -C;
	}
	else if (A == 0 && B < 0) {
		B = -B;
		C = -C;
	}

	return { A, B, C };
}


void solve() {
	ll n; cin >> n;
	set<pair<ll, ll>> st;
	while (n--) {
		char c; cin >> c;
		ll x, y; cin >> x >> y;
		if (c == '+') {
			st.insert({ x, y });
		}
		else {
			st.erase({ x, y });
		}

		if (st.size() < 3) {
			cout << "YES\n";
			continue;
		}

		vector<ll> org = f(st.begin()->first, st.begin()->second, next(st.begin())->first, next(st.begin())->second);
		bool fl = 1;
		for (auto it = next(st.begin()); it != st.end(); it++) {
			if (1ll * it->first * org[0] + 1ll * it->second * org[1] != org[2]) {
				fl = 0;
			}
		}
		cout << (fl ? "YES\n" : "NO\n");
	}
}

int main() {
	cin.tie(0)->sync_with_stdio(false);
	cout.tie(0)->sync_with_stdio(false);
	ll t = 1;
	//cin >> t; comment this line, if no multitests
	while (t--) {
		solve();
		cout << '\n';
	}
}
