#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <map>

/*

10
+ -46767204 -12693732
+ -54034985 -14667103
+ -62535681 -16975239
+ -46213034 -12543262
+ -54219960 -14717328
+ -39203010 -10639878
+ -44384877 -12046875
+ -48777316 -13239524
- -48777316 -13239524
- -62535681 -16975239

*/

using namespace std;
using ll = long long;

ll gcd(ll a, ll b) {
	if (b == 0) return a;
	return gcd(b, a % b);
}

vector<ll> f(ll x1, ll y1, ll x2, ll y2) {
	ll A = y1 - y2;
	ll B = x2 - x1;
	ll C = A * x1 + B * y1;

	if (A == 0 && B == 0) {
		return { 0, 0, 0 };
	}

	ll gcd_ = gcd(gcd(abs(A), abs(B)), abs(C));

	if (gcd != 0) {
		A /= gcd_;
		B /= gcd_;
		C /= gcd_;
	}

	if (A < 0) {
		A = -A;
		B = -B;
		C = -C;
	}
	else if (A == 0 && B < 0) {
		B = -B;
		C = -C;
	}

	return { A, B, C };
}


void solve() {
	int n; cin >> n;

	map<pair<ll, ll>, ll> indx;
	multiset<vector<ll>> dots, lines;
	ll ind = 0;
	while (n--) {
		char c; cin >> c;
		ll x, y; cin >> x >> y;
		if (c == '+') {
			if (!dots.empty()) lines.insert(f(x, y, prev(dots.end())->at(1), prev(dots.end())->at(2)));
			indx[{x, y}] = ind;
			dots.insert({ ind++, x, y });
		}
		else {
			ll id = indx[{x, y}];
			auto it = dots.find({ id, x, y });
			if (it != dots.begin()) {
				auto pit = prev(it);
				lines.erase(lines.find(f(it->at(1), it->at(2), pit->at(1), pit->at(2))));
			}
			if (it != prev(dots.end())) {
				auto nit = next(it);
				lines.erase(lines.find(f(it->at(1), it->at(2), nit->at(1), nit->at(2))));
			}
			if (it != dots.begin() && it != prev(dots.end())) {
				auto pit = prev(it);
				auto nit = next(it);
				lines.insert(f(pit->at(1), pit->at(2), nit->at(1), nit->at(2)));
			}
			dots.erase(it);
		}

		if (lines.empty() || *lines.begin() == *prev(lines.end())) {
			cout << "YES\n";
		}
		else {
			cout << "NO\n";
		}
	}
}

int main() {
	cin.tie(0)->sync_with_stdio(false);
	cout.tie(0)->sync_with_stdio(false);
	int t = 1;
	//cin >> t; comment this line, if no multitests
	while (t--) {
		solve();
	}
}
