#include "testlib.h"
#include "constants.h"

using ll = long long;

using namespace std;

ll get(ll from, ll to) {
    return rnd.next(from, to);
}

template<typename T>
T get_opt(const string &key, const T &d) {
    return has_opt(key) ? opt<T>(key) : d;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    ll max_x_val = get_opt("max_x", constants::MAX_START_VAL);
    ll max_y_val = get_opt("max_y", constants::MAX_START_VAL);
    ll max = get_opt("max", -1);
    if (max != -1) max_x_val = max_y_val = max;

    cout << get(-max_x_val, max_x_val) << ' ' << get(-max_y_val, max_y_val) << '\n';
}
