#include "testlib.h"
#include "constants.h"

using ll = long long;


ll funny_dist(ll x, ll y) {
    x = abs(x);
    y = abs(y);
    if (x < y) std::swap(x, y);
    return x * 2 - (x - y) % 2;
}

int main(int argc, char *argv[]) {
    registerInteraction(argc, argv);

    ll x = inf.readLong(-constants::MAX_START_VAL, constants::MAX_START_VAL, "x0");
    ll y = inf.readLong(-constants::MAX_START_VAL, constants::MAX_START_VAL, "y0");

    for (int requestN = 1;; requestN++) {
        std::string c = ouf.readWord();

        if (c == "?") {
            ll dx = ouf.readLong(-constants::MAX_START_VAL * 2, constants::MAX_START_VAL * 2, "dx");
            ll dy = ouf.readLong(-constants::MAX_START_VAL * 2, constants::MAX_START_VAL * 2, "dy");
            
            ll f1 = funny_dist(x, y);
            x += dx;
            y += dy;
            ll f2 = funny_dist(x, y);

            if (llabs(x) > constants::MAX_TIME_VAL || llabs(y) > constants::MAX_TIME_VAL) {
                std::cout << -1 << std::endl;
                quitf(_wa, "too big coordinates reached: (%lld, %lld) after move (%lld, %lld)", x, y, dx, dy);
            }

            std::cout << f2 - f1 << std::endl;
        } else if (c == "!") {
            ll part_x = ouf.readLong();
            ll part_y = ouf.readLong();

            std::cout << ((part_x == x && part_y == y) ? "Ok" : "Bad") << std::endl;

            tout << requestN << std::endl;

            if (!(part_x == x && part_y == y)) {
                quitf(_wa, "expected (%lld, %lld), got (%lld, %lld).", x, y, part_x, part_y);
            }
            break;
        } else {
            quitf(_wa, "unknown string: %s", c.c_str());
        }
    }

    quitf(_ok, "all testcases passed");
}