#include "testlib.h"

using namespace std;

int n;
const int MAXK = 25;

vector <vector <int>> g, up;
vector <int> tin, ttout, h;
int timer = 0;

void dfs(int v, int p, int k) {
    tin[v] = timer++;
    up[v][0] = p;
    h[v] = k;
    for (int i = 1; i < MAXK; i++) {
        up[v][i] = up[up[v][i - 1]][i - 1];
    }
    for (auto to : g[v]) {
        if (to != p) {
            dfs(to, v, k + 1);
        }
    }
    ttout[v] = timer++;
}

bool upper(int a, int b) {
    return tin[a] <= tin[b] && ttout[a] >= ttout[b];
}

int lca(int a, int b) {
    if (upper(a, b)) {
        return a;
    }
    if (upper(b, a)) {
        return b;
    }
    for (int i = MAXK - 1; i > -1; i--) {
        if (!upper(up[a][i], b)) {
            a = up[a][i];
        }
    }
    return up[a][0];
}

bool check(InStream &in) {
    vector <int> a = in.readInts(n + 1, 1, n, "values");
    for (int i = 0; i < n + 1; i++) {
        a[i]--;
    }
    vector <bool> used(n);
    in.ensuref(a.front() == a.back(), "the response is not a cycle");
    for (int i = 1; i < n + 1; i++) {
        in.ensuref(!used[a[i]], "the response is not a cycle");
        used[a[i]] = true;
        int w = lca(a[i - 1], a[i]);
        if (w == a[i - 1]) {
            in.ensuref(h[a[i]] - h[w] <= 3, "brought out a non-existent edge");
        } else if (w == a[i]) {
            in.ensuref(h[a[i - 1]] - h[w] <= 3, "brought out a non-existent edge");
        } else {
            int q = (h[a[i]] - h[w]) + (h[a[i - 1]] - h[w]);
            in.ensuref(q <= 3, "brought out a non-existent edge");
        }
    }
    return true;
}

int main(int argc, char *argv[]) {

    registerTestlibCmd(argc, argv);

    n = inf.readInt(3, 200000, "n");
    inf.readEoln();
    g.resize(n); up.resize(n, vector <int> (MAXK));
    tin.resize(n); ttout.resize(n); h.resize(n);
    for (int i = 0; i < n - 1; i++) {
        int u = inf.readInt(1, n, "u");
        inf.readSpace();
        int v = inf.readInt(1, n, "u");
        u--; v--;
        g[u].push_back(v);
        g[v].push_back(u);
        inf.readEoln();
    }
    dfs(0, 0, 0);

    check(ouf);
    check(ans);

    quitf(_ok, "OK");
    return 0;
}