#include "testlib.h"

using namespace std;
using ll = long long;

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int min_n = opt<int>("min_n");
    int max_n = opt<int>("max_n");

    int n = rnd.next(min_n, max_n);

    set<pair<int, int>> edges;
    vector <int> nodes;
    int root = rnd.next(1, n);
    nodes.push_back(root);
    for (int i = 1; i <= n; i++) {
        if (i == root) {
            continue;
        }
        int pred = nodes[rnd.next(0, (int)(nodes.size() - 1))];
        edges.insert({pred, i});
        nodes.push_back(i);
    }
    vector <pair<int, int>> result;
    for (auto [u, v] : edges) {
        result.push_back({u, v});
    }
    shuffle(result.begin(), result.end());

    println(n);
    for (auto [u, v] : result) {
        println(u, v);
    }
    return 0;
}