#include "testlib.h"

using namespace std;
using ll = long long;

vector <vector <int>> g;
vector <bool> used;

void dfs(int v) {
    used[v] = true;
    for (auto to : g[v]) {
        if (!used[to]) {
            dfs(to);
        }
    }
}

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int n = inf.readInt(3, 200'000, "n");
    inf.readEoln();

    g.resize(n); used.resize(n);
    for (int i = 0; i < n - 1; i++) {
        int u = inf.readInt(1, n, "u");
        inf.readSpace();
        int v = inf.readInt(1, n, "u");
        ensuref(u != v, "incorrect graph");
        u--; v--;
        g[u].push_back(v);
        g[v].push_back(u);
        inf.readEoln();
    }

    dfs(0);
    for (int i = 0; i < n; i++) {
        ensuref(used[i], "incorrect graph");
    }

    inf.readEof();
    return 0;
}