#include <bits/stdc++.h>
#define int int64_t
using namespace std;
const int inf = 2e17;

template<int mod>
struct Modular {
    int x;
    Modular() {x = 0;}
    Modular(int _x) { x = _x;}
    Modular operator+(const Modular& oth) const {
        int cur = x + oth.x;
        if (cur >= mod) cur -= mod;
        return cur;
    }
    void operator+=(const Modular& oth) {
        x += oth.x;
        if (x >= mod) x -= mod;
    }
    Modular operator-(const Modular& oth) const {
        int cur = x - oth.x;
        if (cur < 0) cur += mod;
        return cur;
    }
    void operator-=(const Modular& oth) {
        x -= oth.x;
        if (x < 0) x += mod;
    }
    Modular operator*(const Modular& oth) const {
        int cur = x * oth.x;
        if (cur >= mod) cur %= mod;
        return cur;
    }
    void operator*=(const Modular& oth) {
        x *= oth.x;
        if (x >= mod) x %= mod;
    }
};

template<int _B, int mod>
struct Hash {

    Modular<mod> B;
    vector<Modular<mod>> pref;
    vector<Modular<mod>> b_pow;
    Hash(string& s) {
        B = _B;
        build(s);
    }
    void build(string& s) {
        pref.resize(s.size() + 1);
        b_pow.resize(s.size() + 1);
        b_pow[0] = 1;
        for (int i = 0; i < s.size(); ++i) {
            b_pow[i + 1] = b_pow[i] * B;
            pref[i + 1] = pref[i] * B + s[i] - 'a' + 1;
        }
    }
    int get_hash(int l, int r) {
        return (pref[r] - pref[l] * b_pow[r - l]).x;
    }
};

struct info {
    int r, cnt, f, s, type;
    info() {}
    info(int r, int cnt, int f, int s, int type): r(r), cnt(cnt), f(f), s(s), type(type) {}
    bool operator<(const info& oth) const {
        if (r < oth.r) return 1;
        else if (r > oth.r) return 0;
        if (f < oth.f) return 1;
        else if (f > oth.f) return 0;
        if (s < oth.s) return 1;
        else if (s > oth.s) return 0;
        if (type < oth.type) return 1;
        else if (type > oth.type) return 0;
        return 0;
    }
};


void solve() {
    string s, a, b;
    cin >> s >> a >> b;
    int n = s.size();
    const int md1 = 1e9 + 7, md2 = 1e9 + 9, B1 = 43, B2 = 113;
    Hash<B1, md1> hs1(s), ha1(a), hb1(b);
    Hash<B2, md2> hs2(s), ha2(a), hb2(b);
    set<info> st;
    st.insert({0, 0, 0, 0, 0});
    for (int i = 0; i < n; ++i) {
        vector<info> toadd;
        for (auto cur: st) {
            int r = cur.r, cnt = cur.cnt, f = cur.f, s = cur.s, type = cur.type;
            if (r < i) continue;
            //if (cnt != mn) break;
            if (type) s -= r - i;
            else f -= r - i;
            int l1 = i, r1 = n + 1;
            while (r1 - l1 > 1) {
                int m = (l1 + r1) / 2;
                if (f + m - i > a.size()) {
                    r1 = m;
                    continue;
                }
                if (hs1.get_hash(i, m) == ha1.get_hash(f, f + m - i) &&
                    hs2.get_hash(i, m) == ha2.get_hash(f, f + m - i)) {
                    l1 = m;
                } else {
                    r1 = m;
                }
            }
            int l2 = i, r2 = n + 1;
            while (r2 - l2 > 1) {
                int m = (l2 + r2) / 2;
                if (s + m - i > b.size()) {
                    r2 = m;
                    continue;
                }
                if (hs1.get_hash(i, m) == hb1.get_hash(s, s + m - i) &&
                    hs2.get_hash(i, m) == hb2.get_hash(s, s + m - i)) {
                    l2 = m;
                } else {
                    r2 = m;
                }
            }
            if (l1 != i) {
                toadd.push_back({l1, cnt + 1, f + l1 - i, s, 0});
            }
            if (l2 != i) {
                toadd.push_back({l2, cnt + 1, f, s + l2 - i, 1});
            }
        }
        while (!st.empty() && (*st.begin()).r <= i) {
            st.erase(st.begin());
        }
        for (auto x: toadd) {
            auto it = st.find(x);
            if (it == st.end()) {
                st.insert(x);
                continue;
            }
            if (it->cnt > x.cnt) {
                st.erase(it);
                st.insert(x);
            }
        }
    }
    //assert(st1.size());
    int mn = inf;
    for (auto cur: st) {
        mn = min(mn, cur.cnt);
    }
    cout << mn - 1;
}

int32_t main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int test = 1;
    //cin >> test;
    while (test--) {
        solve();
    }
}
