#include <bits/stdc++.h>
#include "testlib.h"
#include "constants.h"

using namespace std;
using ll = long long;

vector<ll> mods = {
        1000000007LL,
        1000000009LL, 1000000033LL, 1000000087LL, 1000000093LL, 1000000097LL,
        1000000103LL, 1000000123LL, 1000000181LL, 1000000207LL, 1000000223LL,
        1000000241LL, 1000000271LL, 1000000289LL, 1000000297LL, 1000000321LL
};


vector<ll> get(vector<int> &arr) {
    vector<ll> res;
    res.push_back(std::accumulate(arr.begin(), arr.end(), 0ll));
    for (auto m: mods) {
        ll curmult = 1;
        for (auto i: arr) curmult = (curmult * i) % m;
        res.push_back(curmult);
    }
    return res;
}

struct check_res {
    bool has_answer;
    bool corr_answer;
};

check_res readAndCheckAnswer(InStream &in, int k, const vector<ll> &need, const vector<int> &start) {
    int n = in.readInt(-1, constants::MAX_RES, "ans array len");
    if (n == -1) return {false, {}};
    auto arr = in.readInts(n, 0, k, "array");

    return {true, need == get(arr) && start != arr};
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);

    int n = inf.readInt();
    int k = inf.readInt();
    vector<int> a(n);
    for (int i = 0; i < n; i++) a[i] = inf.readInt();

    auto true_val = get(a);

    auto ja = readAndCheckAnswer(ans, k, true_val, a);
    auto pa = readAndCheckAnswer(ouf, k, true_val, a);

    if (!ja.has_answer) {
        if (!pa.has_answer)
            quitf(_ok, "good boy, answer is -1");
        else if (pa.corr_answer)
            quitf(_fail, "jury hasn't answer but part have");
        else
            quitf(_wa, "not valid answer");
    } else {
        if (!ja.corr_answer)
            quitf(_fail, "jury has not correct answer");
        else if (pa.has_answer && pa.corr_answer)
            quitf(_ok, "good boy, valid answer");
        else if (pa.has_answer && !pa.corr_answer)
            quitf(_wa, "not valid answer");
        else
            quitf(_wa, "part hasn't answer but jury has");
    }
}
