#include "testlib.h"
#include "constants.h"

using namespace std;

using ll = long long;

int get(int from, int to) {
    return rnd.next(from, to);
}

ll get_ll(ll from, ll to) {
    return rnd.next(from, to);
}

template<typename T>
T get_opt(const string &key, const T &d) {
    return has_opt(key) ? opt<T>(key) : d;
}

bool check_prime(int x) {
    if (x < 2) return false;
    for (int i = 2; i * i <= x; i++) if (x % i == 0) return false;
    return true;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int n = get_opt("n", constants::MAX_N);
    int k = get_opt("k", constants::MAX_K);

    int min = get_opt("min", 0);
    int max = get_opt("max", constants::MAX_K);
    int is_prime = get_opt("prime", 0);

    vector<int> primes;
    if (min - max <= 1000) {
        for (int i = min; i <= max; i++) if (check_prime(i)) primes.push_back(i);
    }


    auto f = [&]() {
        if (!is_prime) return get(min, max);
        else if (!primes.empty()) return primes[get(0, primes.size() - 1)];
        else {
            int x = get(min, max);
            while (!check_prime(x)) x = get(min, max);
            return x;
        }
    };

    cout << n << ' ' << k << '\n';
    for (int i = 0; i < n; i++) {
        cout << f();
        if (i + 1 != n) cout << ' ';
    }
    cout << '\n';
}
