#include "testlib.h"

using namespace std;
using ll = long long;

template<typename T>
T get_opt(const string &key, const T &defval) {
    return has_opt(key) ? opt<T>(key) : defval;
}

struct Event {
    ll t;
    int idx;
    ll val;

    bool operator<(const Event &o) const {
        return t < o.t;
    }
};

struct Query {
    ll y, s, t;
};

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int n = get_opt("n", 100000);
    int q = get_opt("q", 100000);
    int maxX = get_opt("X", 1000000000);
    int maxM = get_opt("M", 100000);
    int maxZ = get_opt("Z", 30);
    int p2 = get_opt("p2", 60);
    int maxSteps = get_opt("maxsteps", 18);
    int badrate = get_opt("badrate", 0);

    vector<ll> x(n), m(n), z(n), c(n), a(n);
    for (int i = 0; i < n; i++) {
        x[i] = rnd.next(0, maxX);
        m[i] = rnd.next(0, maxM);
        z[i] = rnd.next(0, maxZ);
        int prob = rnd.next(1, 100);
        if (prob <= p2) c[i] = 2;
        else c[i] = 1;
        a[i] = 1;
    }

    vector<Event> evs;

    for (int i = 0; i < n; i++) {
        if (m[i] == 0) continue;
        if (c[i] == 1) continue;
        ll val = m[i];
        ll t_event = z[i] + 1;
        for (int step = 0; step < maxSteps; step++) {
            val = val / c[i];
            if (t_event > (ll) 1e15) break;
            evs.push_back({t_event, i, val});
            if (val == 0) break;
            t_event += a[i];
        }
    }

    sort(evs.begin(), evs.end(), [](const Event &A, const Event &B) {
        if (A.t != B.t) return A.t < B.t;
        return A.idx < B.idx;
    });

    vector<ll> xs = x;
    sort(xs.begin(), xs.end());

    vector<ll> curM = m;
    ll totalM = 0;
    for (ll v: curM) totalM += v;

    vector<ll> times;
    times.push_back(0);
    for (auto &e: evs) {
        if (times.empty() || times.back() != e.t)
            times.push_back(e.t);
    }

    vector<ll> totalsAtTime;
    totalsAtTime.reserve(times.size());

    size_t ep = 0;
    for (ll tm: times) {
        while (ep < evs.size() && evs[ep].t <= tm) {
            int i = evs[ep].idx;
            ll newv = evs[ep].val;
            totalM += newv - curM[i];
            curM[i] = newv;
            ++ep;
        }
        totalsAtTime.push_back(totalM);
    }

    vector<Query> qs;
    qs.reserve(q);

    for (size_t i = 0; i < times.size() && (int) qs.size() < q; i++) {
        ll tm = times[i];
        ll tot = totalsAtTime[i];

        ll y;
        if (rnd.next(0, 1) == 0 && !xs.empty()) {
            y = xs[rnd.next(0, (int) xs.size() - 1)];
        } else {
            y = rnd.next(0LL, (ll) maxX);
        }

        ll s = 0;
        if (tot > 0) s = rnd.next(0LL, tot);

        qs.push_back({y, s, tm});
    }

    while ((int) qs.size() < q) {
        int idx = rnd.next(0, (int) times.size() - 1);
        ll tm = times[idx];
        ll tot = totalsAtTime[idx];

        ll y;
        if (rnd.next(0, 2) != 0 && !xs.empty()) {
            y = xs[rnd.next(0, (int) xs.size() - 1)];
        } else {
            y = rnd.next(0LL, (ll) maxX);
        }

        ll s = (tot > 0) ? rnd.next(0LL, tot) : 0;

        qs.push_back({y, s, tm});
    }

    if (badrate > 0) {
        int cntBad = (int) ((long long) q * badrate / 100);
        for (int k = 0; k < cntBad; k++) {
            int id = rnd.next(0, q - 1);
            ll y = rnd.next(0LL, (ll) maxX);
            ll s = rnd.next(0LL, (ll) maxM * n);
            ll t = rnd.next(0LL, times.back() + 5);
            qs[id] = {y, s, t};
        }
    }

    shuffle(qs.begin(), qs.end());

    cout << n << " " << q << "\n";
    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << x[i];
    }
    cout << "\n";
    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << m[i];
    }
    cout << "\n";
    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << z[i];
    }
    cout << "\n";
    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << c[i];
    }
    cout << "\n";
    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << a[i];
    }
    cout << "\n";

    for (auto &qq: qs) {
        cout << qq.y << " " << qq.s << " " << qq.t << "\n";
    }
}
