#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;
using ll = long long;

template <typename T>
T get_opt(const string &key, const T &defval) {
    return has_opt(key) ? opt<T>(key) : defval;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int n    = get_opt("n", 100000);
    int q    = get_opt("q", 100000);
    int maxX = get_opt("X", 1000000000);
    int win  = get_opt("win", 50);
    int randqPercent = get_opt("randq", 0);

    vector<int> x(n), m(n), z(n), c(n), a(n);
    for (int i = 0; i < n; i++) {
        x[i] = rnd.next(0, maxX);
        m[i] = rnd.next(0, 100000);
        z[i] = rnd.next(0, 100000);
        c[i] = rnd.next(1, 2);
        a[i] = 1;
    }

    vector<int> ord(n);
    iota(ord.begin(), ord.end(), 0);
    sort(ord.begin(), ord.end(), [&](int i, int j) {
        return x[i] < x[j];
    });

    vector<ll> prefM(n + 1, 0);
    for (int idx = 0; idx < n; idx++) {
        prefM[idx + 1] = prefM[idx] + m[ord[idx]];
    }

    ll globalSumM = 0;
    ll globalBestZplus = (ll)1e18;
    for (int i = 0; i < n; i++) {
        globalSumM += m[i];
    }
    globalBestZplus = (ll)1e18;
    for (int i = 0; i < n; i++) {
        globalBestZplus = min(globalBestZplus, (ll)z[i] + 1);
    }
    if (globalBestZplus == (ll)1e18) globalBestZplus = 0;

    cout << n << " " << q << "\n";

    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << x[i];
    }
    cout << "\n";

    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << m[i];
    }
    cout << "\n";

    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << z[i];
    }
    cout << "\n";

    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << c[i];
    }
    cout << "\n";

    for (int i = 0; i < n; i++) {
        if (i) cout << ' ';
        cout << a[i];
    }
    cout << "\n";

    for (int j = 0; j < q; j++) {
        bool makeRandom = (rnd.next(0, 99) < randqPercent);

        ll y, sreq, treq;

        if (makeRandom) {
            y = rnd.next(0, maxX);

            ll smax = globalSumM;
            ll tmax = globalBestZplus;
            sreq = rnd.next(0LL, smax);
            treq = rnd.next(0LL, tmax);
        } else {
            int startPos = rnd.next(0, n - 1);
            int len = rnd.next(1, min(win, n - startPos));
            int endPos = startPos + len - 1;

            int Lx = x[ord[startPos]];
            int Rx = x[ord[endPos]];
            if (Lx > Rx) swap(Lx, Rx);

            y = rnd.next(Lx, Rx);

            ll windowSumM = prefM[endPos + 1] - prefM[startPos];

            ll windowMinZplus = (ll)1e18;
            for (int pos = startPos; pos <= endPos; pos++) {
                int id = ord[pos];
                windowMinZplus = min(windowMinZplus, (ll)z[id] + 1);
            }
            if (windowMinZplus == (ll)1e18) windowMinZplus = 0;

            sreq = rnd.next(0LL, windowSumM);
            treq = rnd.next(0LL, windowMinZplus);
        }

        cout << y << " " << sreq << " " << treq << "\n";
    }
}
