#include <bits/stdc++.h>

using namespace std;

using ll = long long;

struct Fenwick {
    int n;
    vector<ll> bit;

    Fenwick(int n = 0) { init(n); }

    void init(int n_) {
        n = n_;
        bit.assign(n + 1, 0);
    }

    void add(int idx, ll delta) {
        for (++idx; idx <= n; idx += idx & -idx)
            bit[idx] += delta;
    }

    ll sumPrefix(int idx) const {
        ll r = 0;
        for (++idx; idx > 0; idx -= idx & -idx)
            r += bit[idx];
        return r;
    }

    ll sumRange(int l, int r) const {
        if (r < l) return 0;
        return sumPrefix(r) - (l ? sumPrefix(l - 1) : 0);
    }
};

struct Query {
    ll y, s, t;
    int id;
};

struct Event {
    ll t;
    int idx;
    ll val;

    bool operator<(Event const &o) const {
        return t < o.t;
    }
};

int main() {
    int n, q;
    cin >> n >> q;

    vector<ll> x(n);
    for (int i = 0; i < n; ++i) cin >> x[i];

    vector<ll> m(n);
    for (int i = 0; i < n; ++i) cin >> m[i];

    vector<ll> z(n);
    for (int i = 0; i < n; ++i) cin >> z[i];

    vector<ll> c(n);
    for (int i = 0; i < n; ++i) cin >> c[i];

    vector<ll> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];

    vector<Query> qs(q);
    ll maxT = 0;
    for (int j = 0; j < q; ++j) {
        cin >> qs[j].y >> qs[j].s >> qs[j].t;
        qs[j].id = j;
        maxT = max(maxT, qs[j].t);
    }

    vector<pair<ll, int>> ord(n);
    for (int i = 0; i < n; ++i) ord[i] = {x[i], i};
    sort(ord.begin(), ord.end());

    vector<ll> xs(n);
    vector<int> pos(n);
    for (int idx = 0; idx < n; ++idx) {
        xs[idx] = ord[idx].first;
        pos[ord[idx].second] = idx;
    }

    Fenwick fw(n);
    vector<ll> curVal(n);
    for (int idx = 0; idx < n; ++idx) {
        int i = ord[idx].second;
        curVal[i] = m[i];
        fw.add(idx, m[i]);
    }

    vector<Event> evs;
    for (int i = 0; i < n; ++i) {
        if (m[i] == 0) continue;
        if (c[i] == 1) {
            continue;
        }
        ll val = m[i];
        ll t_event = z[i] + 1;
        while (t_event <= maxT) {
            val = val / c[i];
            if (val < 0) val = 0;
            evs.push_back({t_event, i, val});
            if (val == 0) break;
            t_event += a[i];
        }
    }

    sort(evs.begin(), evs.end());
    sort(qs.begin(), qs.end(), [](const Query &A, const Query &B) {
        return A.t < B.t;
    });

    vector<ll> ans(q, -1);
    size_t ep = 0;

    for (auto const &qu: qs) {
        ll needT = qu.t;
        while (ep < evs.size() && evs[ep].t <= needT) {
            int i = evs[ep].idx;
            ll nv = evs[ep].val;
            int p = pos[i];
            ll delta = nv - curVal[i];
            if (delta != 0) {
                fw.add(p, delta);
                curVal[i] = nv;
            }
            ++ep;
        }

        ll total = fw.sumRange(0, n - 1);
        if (total < qu.s) {
            ans[qu.id] = -1;
            continue;
        }

        ll y = qu.y;
        ll maxDist = max(llabs(xs.front() - y), llabs(xs.back() - y));
        ll lo = 0, hi = maxDist;
        while (lo < hi) {
            ll mid = (lo + hi) / 2;
            ll L = y - mid;
            ll R = y + mid;
            int left = int(lower_bound(xs.begin(), xs.end(), L) - xs.begin());
            int right = int(upper_bound(xs.begin(), xs.end(), R) - xs.begin()) - 1;
            ll got = fw.sumRange(left, right);
            if (got >= qu.s) {
                hi = mid;
            } else {
                lo = mid + 1;
            }
        }
        ans[qu.id] = lo;
    }

    for (int i = 0; i < q; ++i) {
        cout << ans[i] << '\n';
    }
}
