#include <bits/stdc++.h>

using namespace std;

using ll = long long;

struct segment_tree {
private:
    vector<ll> tree;
    int n;

public:
    explicit segment_tree(const vector<int> &data) {
        n = (int) data.size();
        tree.resize(4 * n);
        build(1, 0, n, data);
    }

    explicit segment_tree(int n_) : segment_tree(vector<int> (n_)) {}

private:
    void build(int v, int l, int r, const vector<int> &data) {
        if (l + 1 == r) {
            tree[v] = data[l];
            return;
        }
        int m = (l + r) / 2;
        build(v * 2, l, m, data);
        build(v * 2 + 1, m, r, data);
        tree[v] = tree[v * 2] + tree[v * 2 + 1];
    }

    ll get(int v, int l, int r, int lq, int rq) {
        if (lq >= r || l >= rq) return 0;
        if (lq <= l && r <= rq) return tree[v];
        int m = (l + r) / 2;
        return get(v * 2, l, m, lq, rq) + get(v * 2 + 1, m, r, lq, rq);
    }

    void update(int v, int l, int r, int ind, int val) {
        if (l + 1 == r) {
            tree[v] += val;
            return;
        }
        int m = (l + r) / 2;
        if (ind < m) update(v * 2, l, m, ind, val);
        else update(v * 2 + 1, m, r, ind, val);
        tree[v] = tree[v * 2] + tree[v * 2 + 1];
    }

public:
    ll get(int left, int right) {
        return get(1, 0, n, left, right + 1);
    }

    void upd(int index, int value) {
        update(1, 0, n, index, value);
    }
};

struct Query {
    ll y, s, t;
    int id;
};

struct Event {
    ll t;
    int idx;
    ll val;

    bool operator<(Event const &o) const {
        return t < o.t;
    }
};

int main() {
    int n, q;
    cin >> n >> q;

    vector<ll> x(n);
    for (int i = 0; i < n; ++i) cin >> x[i];

    vector<ll> m(n);
    for (int i = 0; i < n; ++i) cin >> m[i];

    vector<ll> z(n);
    for (int i = 0; i < n; ++i) cin >> z[i];

    vector<ll> c(n);
    for (int i = 0; i < n; ++i) cin >> c[i];

    vector<ll> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];

    vector<Query> qs(q);
    ll maxT = 0;
    for (int j = 0; j < q; ++j) {
        cin >> qs[j].y >> qs[j].s >> qs[j].t;
        qs[j].id = j;
        maxT = max(maxT, qs[j].t);
    }

    vector<pair<ll, int>> ord(n);
    for (int i = 0; i < n; ++i) ord[i] = {x[i], i};
    sort(ord.begin(), ord.end());

    vector<ll> xs(n);
    vector<int> pos(n);
    for (int idx = 0; idx < n; ++idx) {
        xs[idx] = ord[idx].first;
        pos[ord[idx].second] = idx;
    }

    segment_tree fw(n);
    vector<ll> curVal(n);
    for (int idx = 0; idx < n; ++idx) {
        int i = ord[idx].second;
        curVal[i] = m[i];
        fw.upd(idx, m[i]);
    }

    vector<Event> evs;
    for (int i = 0; i < n; ++i) {
        if (m[i] == 0) continue;
        if (c[i] == 1) {
            continue;
        }
        ll val = m[i];
        ll t_event = z[i] + 1;
        while (t_event <= maxT) {
            val = val / c[i];
            if (val < 0) val = 0;
            evs.push_back({t_event, i, val});
            if (val == 0) break;
            t_event += a[i];
        }
    }

    sort(evs.begin(), evs.end());
    sort(qs.begin(), qs.end(), [](const Query &A, const Query &B) {
        return A.t < B.t;
    });

    vector<ll> ans(q, -1);
    size_t ep = 0;

    for (auto const &qu: qs) {
        ll needT = qu.t;
        while (ep < evs.size() && evs[ep].t <= needT) {
            int i = evs[ep].idx;
            ll nv = evs[ep].val;
            int p = pos[i];
            ll delta = nv - curVal[i];
            if (delta != 0) {
                fw.upd(p, delta);
                curVal[i] = nv;
            }
            ++ep;
        }

        ll total = fw.get(0, n - 1);
        if (total < qu.s) {
            ans[qu.id] = -1;
            continue;
        }

        ll y = qu.y;
        ll maxDist = max(llabs(xs.front() - y), llabs(xs.back() - y));
        ll lo = 0, hi = maxDist;
        while (lo < hi) {
            ll mid = (lo + hi) / 2;
            ll L = y - mid;
            ll R = y + mid;
            int left = int(lower_bound(xs.begin(), xs.end(), L) - xs.begin());
            int right = int(upper_bound(xs.begin(), xs.end(), R) - xs.begin()) - 1;
            ll got = fw.get(left, right);
            if (got >= qu.s) {
                hi = mid;
            } else {
                lo = mid + 1;
            }
        }
        ans[qu.id] = lo;
    }

    for (int i = 0; i < q; ++i) {
        cout << ans[i] << '\n';
    }
}
