#include "bits/stdc++.h"

using namespace std;

#pragma GCC optimize("O3,unroll-loops")

vector<long long> hadamard_transform(const vector<long long>& a) {
    vector<long long> dp = a;
    for (size_t bit = 1; bit < a.size(); bit <<= 1) {
        for (size_t mask = 0; mask < a.size(); mask++) {
            if ((mask & bit) == 0) {
                long long u = dp[mask], v = dp[mask ^ bit];
                dp[mask] = u + v;
                dp[mask ^ bit] = u - v;
            }
        }
    }
    return dp;
}

vector<long long> inverse_hadamard_transform(const vector<long long>& f) {
    vector<long long> dp = f;
    for (size_t bit = 1; bit < f.size(); bit <<= 1) {
        for (size_t mask = 0; mask < f.size(); mask++) {
            if ((mask & bit) == 0) {
                long long x = dp[mask], y = dp[mask ^ bit];
                dp[mask] = (x + y) / 2;
                dp[mask ^ bit] = (x - y) / 2;
            }
        }
    }
    return dp;
}

vector<long long> xor_convolution(vector<long long> a, vector<long long> b) {
    int x = 1;
    while (x < a.size() || x < b.size()) x *= 2;
    a.resize(x, 0);
    b.resize(x, 0);

    vector<long long> f = hadamard_transform(a);
    vector<long long> g = hadamard_transform(b);
    vector<long long> h(f.size());
    for (size_t i = 0; i < f.size(); i++) {
        h[i] = f[i] * g[i];
    }
    vector<long long> c = inverse_hadamard_transform(h);
    return c;
}

void dfs(int i, int p, vector<vector<pair<int, int>>>& g, vector<long long>& calc, int x) {
    calc[x]++;

    for (auto [j, c] : g[i]) {
        if (j == p) continue;

        dfs(j, i, g, calc, x ^ c);
    }
}

int main(int argc, char *argv[]) {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n; cin >> n;
    vector<vector<pair<int, int>>> g(n);
    for (int i = 0; i < n  - 1; ++i) {
        int a, b, c; cin >> a >> b >> c;
        --a; --b;

        g[a].push_back({b, c});
        g[b].push_back({a, c});
    }

    vector<long long> calc(1 << 20);
    dfs(0, -1, g, calc, 0);

    vector<long long> ans = xor_convolution(calc, calc);

    int q; cin >> q;
    while (q--) {
        int a; cin >> a;

        if (a == 0) {
            cout << (ans[a] - n) / 2 << "\n";
        } else cout << ans[a] / 2 << "\n";
    }
}
