#include <bits/stdc++.h>
using namespace std;

const double EPS = 1e-9;

double targetT;
double fullTime[4];
bool possible;

void dfs(array<double, 4> remain, array<int, 4> speed, double curT) {
    if (possible) return;

    // Попали ровно в нужное время
    if (fabs(curT - targetT) < EPS) {
        possible = true;
        return;
    }
    // Ушли дальше
    if (curT > targetT + EPS) return;

    // Ищем ближайшее событие: какая-то горящая верёвка догорит
    double dt = 1e100;
    bool anyBurning = false;
    for (int i = 0; i < 4; ++i) {
        if (speed[i] > 0 && remain[i] > EPS) {
            anyBurning = true;
            dt = min(dt, remain[i] / (double)speed[i]);
        }
    }
    if (!anyBurning) return; // ничего не горит — событий больше не будет

    // Если следующее событие произойдёт позже t, смысла нет
    if (curT + dt > targetT + EPS) return;

    // Продвигаемся до ближайшего события
    array<double, 4> nextRemain = remain;
    for (int i = 0; i < 4; ++i) {
        if (speed[i] > 0 && nextRemain[i] > EPS) {
            nextRemain[i] -= speed[i] * dt;
            if (nextRemain[i] < EPS) nextRemain[i] = 0.0;
        }
    }
    double nextT = curT + dt;

    // Событие ровно в t
    if (fabs(nextT - targetT) < EPS) {
        possible = true;
        return;
    }

    // Какие верёвки ещё живы
    int aliveMask = 0;
    for (int i = 0; i < 4; ++i) {
        if (nextRemain[i] > EPS) aliveMask |= (1 << i);
    }
    if (aliveMask == 0) return; // всё сгорело

    array<int, 4> nextSpeed;

    // Перебор всех вариантов 0/1/2 концов для живых верёвок
    function<void(int)> rec = [&](int idx) {
        if (idx == 4) {
            bool any = false;
            for (int i = 0; i < 4; ++i)
                if (nextSpeed[i] > 0) any = true;
            if (!any) return; // должно что-то гореть
            dfs(nextRemain, nextSpeed, nextT);
            return;
        }

        if (!(aliveMask & (1 << idx))) {
            // верёвка уже сгорела
            nextSpeed[idx] = 0;
            rec(idx + 1);
        } else {
            // верёвка жива: 0, 1 или 2 конца
            for (int v = 0; v <= 2; ++v) {
                nextSpeed[idx] = v;
                rec(idx + 1);
            }
        }
    };

    rec(0);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int q;
    if (!(cin >> q)) return 0;

    while (q--) {
        // формат: 4 верёвки, потом t
        for (int i = 0; i < 4; ++i) cin >> fullTime[i];
        cin >> targetT;

        possible = false;

        if (fabs(targetT) < EPS) {
            cout << "YES\n";
            continue;
        }

        array<double, 4> startRemain;
        for (int i = 0; i < 4; ++i) startRemain[i] = fullTime[i];

        array<int, 4> startSpeed;

        // В момент времени 0 выбираем стартовую конфигурацию скоростей (0/1/2 концов),
        // хотя бы одна верёвка должна гореть.
        function<void(int)> recStart = [&](int idx) {
            if (idx == 4) {
                bool any = false;
                for (int i = 0; i < 4; ++i)
                    if (startSpeed[i] > 0) any = true;
                if (!any) return;
                dfs(startRemain, startSpeed, 0.0);
                return;
            }
            // все 4 верёвки изначально живы
            for (int v = 0; v <= 2; ++v) {
                startSpeed[idx] = v;
                recStart(idx + 1);
            }
        };

        recStart(0);

        cout << (possible ? "YES\n" : "NO\n");
    }

    return 0;
}
