#include "testlib.h"
#include <bits/stdc++.h>

using namespace std;

/*------------------------------------------------------------
   Validator for task «Президент мира»

   Input format (briefly):
   t                     – number of test cases, 1 … 500
   For each test case
       q                 – number of queries, 1 … 4·10⁵
       q lines with one of the forms
           + xi ki       – add person (1 … 10³, 1 … 2·10⁵)
           - xi ki       – delete person (guaranteed to exist)
           ? ti          – ask day        (1 … 2·10⁵)

   Global constraints:
     Σq over all tests ≤ 4·10⁵
 ------------------------------------------------------------*/

struct PairHash {
    size_t operator()(const pair<int,int>& p) const noexcept {
        return (static_cast<size_t>(p.first) << 20) ^ p.second;
    }
};

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    const int MAX_TCASES   = 500;
    const int MAX_Q        = 400'000;
    const int MAX_X        = 1'000;
    const int MAX_KI       = 200'000;
    const int MAX_TI       = 200'000;

    int t = inf.readInt(1, MAX_TCASES, "t");
    inf.readEoln();

    long long totalQ = 0;

    for (int tc = 1; tc <= t; ++tc) {
        setTestCase(tc);

        int q = inf.readInt(1, MAX_Q, "q");
        inf.readEoln();

        totalQ += q;
        ensuref(totalQ <= MAX_Q, "Σq across tests must not exceed %d, now %lld",
                MAX_Q, totalQ);

        /* multiset of (xi, ki) currently alive */
        unordered_map<pair<int,int>, int, PairHash> alive;

        for (int i = 0; i < q; ++i) {
            char op = inf.readChar();
            ensuref(op == '+' || op == '-' || op == '?',
                    "Invalid operation character (query %d in test %d)", i + 1, tc);

            if (op == '+' || op == '-') {
                inf.readSpace();
                int xi = inf.readInt(1, MAX_X, "xi");
                inf.readSpace();
                int ki = inf.readInt(1, MAX_KI, "ki");
                inf.readEoln();

                pair<int,int> key = {xi, ki};

                if (op == '+') {
                    ++alive[key];
                } else {                 // '-'
                    auto it = alive.find(key);
                    ensuref(it != alive.end() && it->second > 0,
                            "Attempt to delete non-existing person (xi=%d, ki=%d) "
                            "at query %d in test %d", xi, ki, i + 1, tc);
                    if (--it->second == 0) alive.erase(it);
                }
            } else {                    // '?'
                inf.readSpace();
                inf.readInt(1, MAX_TI, "ti");
                inf.readEoln();
            }
        }
    }

    inf.readEof();
}
