#include <utility>
#include "testlib.h"
#include <vector>
#include "constants.h"

using namespace std;
using ll = long long;

inline int get(int from, int to) { return rnd.next(from, to); }

template<typename T>
T get_opt(const string &key, const T &def) {
    return has_opt(key) ? opt<T>(key) : def;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int q = get_opt("q", constants::MAX_Q);
    int maxX = get_opt("x", constants::MAX_X);
    int maxK = get_opt("k", constants::MAX_k);
    int maxT = get_opt("T", constants::MAX_t);
    int prefill_pct = get_opt("prefill", 0);

    prefill_pct = max(0, min(prefill_pct, 100));

    cout << q << '\n';

    int pre_add_cnt = (int) ((1LL * q * prefill_pct) / 100);

    vector<pair<int, int>> active;
    active.reserve(q);

    for (int i = 0; i < pre_add_cnt; ++i) {
        int x = get(1, maxX);
        int k = get(1, maxK);
        active.emplace_back(x, k);
        cout << "+ " << x << ' ' << k << '\n';
    }

    for (int i = pre_add_cnt; i < q; ++i) {
        bool can_remove = !active.empty();

        int op_type;
        if (!can_remove) {
            op_type = get(1, 2);
        } else {
            op_type = get(1, 3);
        }

        if (op_type == 1) {
            int x = get(1, maxX);
            int k = get(1, maxK);
            active.emplace_back(x, k);
            cout << "+ " << x << ' ' << k << '\n';
        } else if (op_type == 2) {
            int Ti = get(1, maxT);
            cout << "? " << Ti << '\n';
        } else {
            int idx = get(0, (int) active.size() - 1);
            auto [x, k] = active[idx];
            cout << "- " << x << ' ' << k << '\n';
            active[idx] = active.back();
            active.pop_back();
        }
    }

}
