#include "testlib.h"
#include "constants.h"

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);


    int q = inf.readInt(1, constants::MAX_Q, "q");
    inf.readEoln();
    std::map<std::pair<int, int>, int> cnt;
    for (int i = 1; i <= q; i++) {
        std::string pattern = ::format("[+-?]{1}");
        auto type = inf.readToken(pattern, "s");
        inf.readSpace();
        if (type == "+") {
            int x = inf.readInt(1, constants::MAX_X, "x");
            inf.readSpace();
            int k = inf.readInt(1, constants::MAX_k, "k");
            cnt[{x, k}]++;
        } else if (type == "-") {
            int x = inf.readInt(1, constants::MAX_X, "x");
            inf.readSpace();
            int k = inf.readInt(1, constants::MAX_k, "k");
            ensuref(--cnt[{x, k}] >= 0, "can't remove unexist person");
        } else if (type == "?") {
            inf.readInt(1, constants::MAX_t, "t");
        } else ensuref(false, "?????");
        inf.readEoln();
    }

    inf.readEof();
}
