#include <bits/stdc++.h>

using namespace std;

const int MAXM = 200005;
const int B = 800;

struct SegmentTree {
    int n;
    vector<long long> lazy;

    SegmentTree(int _n) {
        n = _n;
        lazy.assign(4 * n + 4, 0);
    }

    void range_add(int node, int l, int r, int ql, int qr, int v) {
        if (ql > r || qr < l) return;
        if (ql <= l && r <= qr) {
            lazy[node] += v;
            return;
        }
        int mid = (l + r) >> 1;
        range_add(node << 1, l, mid, ql, qr, v);
        range_add(node << 1 | 1, mid + 1, r, ql, qr, v);
    }

    long long point_query(int node, int l, int r, int idx) const {
        if (l == r) {
            return lazy[node];
        }
        int mid = (l + r) >> 1;
        if (idx <= mid) {
            return lazy[node] + point_query(node << 1, l, mid, idx);
        } else {
            return lazy[node] + point_query(node << 1 | 1, mid + 1, r, idx);
        }
    }

    void range_add(int l, int r, int v) {
        if (l > r) return;
        range_add(1, 1, n, l, r, v);
    }
    long long point_query(int idx) const {
        return point_query(1, 1, n, idx);
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t = 1;

    while (t--) {
        int q;
        cin >> q;

        vector<long long> S(B, 0);
        SegmentTree seg(MAXM + 2);

        while (q--) {
            char op;
            cin >> op;
            if (op == '+' || op == '-') {
                int x, k;
                cin >> x >> k;
                int sign = (op == '+' ? 1 : -1);

                if (k < B) {
                    S[k] += sign * x;
                } else {
                    int cycle = 2 * k;
                    for (int start = 1; start <= MAXM; start += cycle) {
                        int l = start;
                        int r = start + k - 1;
                        if (r > MAXM) r = MAXM;
                        seg.range_add(l, r, sign * x);
                    }
                }
            } else if (op == '?') {
                int ti;
                cin >> ti;
                long long ans = seg.point_query(ti);
                for (int k = 1; k < B; k++) {
                    if (S[k] == 0) continue;
                    int d = (ti - 1) % (2 * k);
                    if (d < k) {
                        ans += S[k];
                    }
                }
                cout << ans << "\n";
            }
        }
    }

    return 0;
}
